/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.jingle.nat.ICECandidate;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JingleTransport
implements PacketExtension {
    public static final String NODENAME = "transport";
    protected String namespace;
    protected final List<JingleTransportCandidate> candidates = new ArrayList<JingleTransportCandidate>();

    public JingleTransport() {
    }

    public JingleTransport(JingleTransportCandidate candidate) {
        this.addCandidate(candidate);
    }

    public JingleTransport(JingleTransport tr) {
        if (tr != null) {
            this.namespace = tr.namespace;
            if (tr.candidates.size() > 0) {
                this.candidates.addAll(tr.candidates);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCandidate(JingleTransportCandidate candidate) {
        if (candidate != null) {
            List<JingleTransportCandidate> list = this.candidates;
            synchronized (list) {
                this.candidates.add(candidate);
            }
        }
    }

    public Iterator getCandidates() {
        return Collections.unmodifiableList(this.getCandidatesList()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JingleTransportCandidate> getCandidatesList() {
        ArrayList<JingleTransportCandidate> res = null;
        List<JingleTransportCandidate> list = this.candidates;
        synchronized (list) {
            res = new ArrayList<JingleTransportCandidate>(this.candidates);
        }
        return res;
    }

    public int getCandidatesCount() {
        return this.getCandidatesList().size();
    }

    public String getElementName() {
        return NODENAME;
    }

    protected void setNamespace(String ns) {
        this.namespace = ns;
    }

    public String getNamespace() {
        return this.namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(this.getElementName()).append(" xmlns=\"");
        buf.append(this.getNamespace()).append("\" ");
        List<JingleTransportCandidate> list = this.candidates;
        synchronized (list) {
            if (this.getCandidatesCount() > 0) {
                buf.append(">");
                Iterator iter = this.getCandidates();
                while (iter.hasNext()) {
                    JingleTransportCandidate candidate = (JingleTransportCandidate)iter.next();
                    buf.append(candidate.toXML());
                }
                buf.append("</").append(this.getElementName()).append(">");
            } else {
                buf.append("/>");
            }
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RawUdp
    extends JingleTransport {
        public static final String NAMESPACE = "http://www.xmpp.org/extensions/xep-0177.html#ns";

        public RawUdp() {
            this.setNamespace(NAMESPACE);
        }

        @Override
        public void addCandidate(JingleTransportCandidate candidate) {
            this.candidates.clear();
            super.addCandidate(candidate);
        }

        @Override
        public List<JingleTransportCandidate> getCandidatesList() {
            ArrayList<JingleTransportCandidate> copy = new ArrayList<JingleTransportCandidate>();
            List<JingleTransportCandidate> superCandidatesList = super.getCandidatesList();
            if (superCandidatesList.size() > 0) {
                copy.add(superCandidatesList.get(0));
            }
            return copy;
        }

        public static class Candidate
        extends JingleTransportCandidate {
            public Candidate() {
            }

            public Candidate(TransportCandidate tc) {
                super(tc);
            }

            protected String getChildElements() {
                StringBuilder buf = new StringBuilder();
                if (this.transportCandidate != null && this.transportCandidate instanceof TransportCandidate.Fixed) {
                    TransportCandidate.Fixed tcf = (TransportCandidate.Fixed)this.transportCandidate;
                    buf.append(" generation=\"").append(tcf.getGeneration()).append("\"");
                    buf.append(" ip=\"").append(tcf.getIp()).append("\"");
                    buf.append(" port=\"").append(tcf.getPort()).append("\"");
                    String name = tcf.getName();
                    if (name != null) {
                        buf.append(" name=\"").append(name).append("\"");
                    }
                }
                return buf.toString();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Ice
    extends JingleTransport {
        public static final String NAMESPACE = "urn:xmpp:tmp:jingle:transports:ice-udp";

        public Ice() {
            this.setNamespace(NAMESPACE);
        }

        @Override
        public void addCandidate(JingleTransportCandidate candidate) {
            super.addCandidate(candidate);
        }

        @Override
        public List<JingleTransportCandidate> getCandidatesList() {
            ArrayList<JingleTransportCandidate> copy = new ArrayList<JingleTransportCandidate>();
            List<JingleTransportCandidate> superCandidatesList = super.getCandidatesList();
            for (int i = 0; i < superCandidatesList.size(); ++i) {
                copy.add(superCandidatesList.get(i));
            }
            return copy;
        }

        public static class Candidate
        extends JingleTransportCandidate {
            public Candidate() {
            }

            public Candidate(TransportCandidate tc) {
                super(tc);
            }

            protected String getChildElements() {
                StringBuilder buf = new StringBuilder();
                if (this.transportCandidate != null) {
                    ICECandidate tci = (ICECandidate)this.transportCandidate;
                    buf.append(" generation=\"").append(tci.getGeneration()).append("\"");
                    buf.append(" ip=\"").append(tci.getIp()).append("\"");
                    buf.append(" port=\"").append(tci.getPort()).append("\"");
                    buf.append(" network=\"").append(tci.getNetwork()).append("\"");
                    buf.append(" username=\"").append(tci.getUsername()).append("\"");
                    buf.append(" password=\"").append(tci.getPassword()).append("\"");
                    buf.append(" preference=\"").append(tci.getPreference()).append("\"");
                    buf.append(" type=\"").append((Object)tci.getType()).append("\"");
                    if (this.transportCandidate.getName() != null) {
                        buf.append(" name=\"").append(tci.getName()).append("\"");
                    }
                }
                return buf.toString();
            }
        }
    }

    public static abstract class JingleTransportCandidate {
        public static final String NODENAME = "candidate";
        protected TransportCandidate transportCandidate;

        public JingleTransportCandidate() {
        }

        public JingleTransportCandidate(TransportCandidate candidate) {
            this.setMediaTransport(candidate);
        }

        public static String getElementName() {
            return NODENAME;
        }

        public TransportCandidate getMediaTransport() {
            return this.transportCandidate;
        }

        public void setMediaTransport(TransportCandidate cand) {
            if (cand != null) {
                this.transportCandidate = cand;
            }
        }

        protected String getChildElements() {
            return null;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            String childElements = this.getChildElements();
            if (this.transportCandidate != null && childElements != null) {
                buf.append("<").append(JingleTransportCandidate.getElementName()).append(" ");
                buf.append(childElements);
                buf.append("/>");
            }
            return buf.toString();
        }
    }
}

