package com.beem.project.beem.ui;

import java.util.ArrayList;

import android.app.ListActivity;
import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnKeyListener;
import android.widget.ArrayAdapter;
import android.widget.EditText;

import com.beem.project.beem.BeemApplication;
import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;
import com.beem.project.beem.service.Message;
import com.beem.project.beem.service.aidl.IChat;
import com.beem.project.beem.service.aidl.IChatManager;
import com.beem.project.beem.service.aidl.IChatManagerListener;
import com.beem.project.beem.service.aidl.IMessageListener;
import com.beem.project.beem.service.aidl.IXmppFacade;

/**
 * @author barbu This activity class provide the view for instant messaging
 *         after selecting a correspondant.
 */

public class SendIM extends ListActivity implements OnClickListener,
	OnKeyListener {
    private EditText mToSend;
    private ArrayList<String> mMessages = new ArrayList<String>();
    private ArrayAdapter<String> mAdapter;
    private SendIMDialogSmiley mSmyDialog;
    private SharedPreferences mSet;
    private SharedPreferences mGlobalSettings;
    private BeemApplication mBeemApplication;
    private Handler mHandler;
    private IXmppFacade mService = null;
    private Contact mContact;
    private IChatManager mChatManager;
    private IChatManagerListener mChatManagerListener;
    private IMessageListener mMessageListener;
    private IChat mChat;

    /**
     * Constructor.
     */
    public SendIM() {
	super();
    }

    /**
     * Overload of onCreate() Activity inherited function
     */
    @Override
    public void onCreate(Bundle saveBundle) {
	super.onCreate(saveBundle);
	mHandler = new Handler();
	mChatManagerListener = new OnChatListener();
	mMessageListener = new OnMessageListener();
	mBeemApplication = BeemApplication.getApplication(this);
	setContentView(R.layout.sendim);
	mToSend = (EditText) findViewById(R.id.userText);
	mSet = getSharedPreferences("lol", MODE_PRIVATE);
	mSmyDialog = new SendIMDialogSmiley(this, mSet);
	mGlobalSettings = getSharedPreferences(getString(R.string.PreferenceFileName), MODE_PRIVATE);

	mAdapter = new ArrayAdapter<String>(this, R.layout.messagelist,
		mMessages);
	setListAdapter(mAdapter);

	mToSend.setOnClickListener(this);
	mToSend.setOnKeyListener(this);

	mContact = getIntent().getParcelableExtra("contact");
    }

    @Override
    public void onStart() {
	super.onStart();
	mBeemApplication.startBeemService();
	mService = mBeemApplication.getXmppFacade();
	try {
	    mChatManager = mService.getChatManager();
	    mChatManager.addChatCreationListener(mChatManagerListener);
	    mChat = mChatManager.createChat(mContact, mMessageListener);
	} catch (RemoteException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	}
    }

    /**
     * Abstract method inherited from OnClickListener
     */
    public void onClick(View view) {
	sendText();
    }

    /**
     * This method send a message to the server over the XMPP connection and
     * display it on activity view TODO : Exception si la connexion se coupe
     * pendant la conversation
     */
    private void sendText() {
	String text = mToSend.getText().toString();
	String from = mGlobalSettings.getString(getString(R.string.PreferenceJID), "You");
	if (!text.equals("")) {
	    Message msg = new Message(mContact.getJID(), Message.MSG_TYPE_CHAT);
	    msg.setBody(text);
	    try {
		mChat.sendMessage(msg);
	    } catch (RemoteException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	    }
	    mAdapter.add(from + getString(R.string.SendIMSays) + text);
	    mToSend.setText(null);
	}
    }

    /**
     * Abstract method inherited from OnKeyListener
     */
    public boolean onKey(View v, int keyCode, KeyEvent event) {
	if (event.getAction() == KeyEvent.ACTION_DOWN) {
	    switch (keyCode) {
		case KeyEvent.KEYCODE_DPAD_CENTER:
		case KeyEvent.KEYCODE_ENTER:
		    sendText();
		    return true;
	    }
	}
	return false;
    }

    /**
     * Callback for menu creation.
     * 
     * @param menu
     *            the menu created
     * @return true on success, false otherwise
     */
    @Override
    public final boolean onCreateOptionsMenu(Menu menu) {
	super.onCreateOptionsMenu(menu);
	MenuInflater inflater = getMenuInflater();
	inflater.inflate(R.menu.sendimmenu, menu);
	return true;
    }

    @Override
    public final boolean onOptionsItemSelected(MenuItem item) {
	switch (item.getItemId()) {
	    case R.id.sendim_smiley:
		mSmyDialog.show();
		return true;
	    default:
		return false;
	}
    }
    
    private class OnChatListener extends IChatManagerListener.Stub {

	@Override
	public void chatCreated(IChat chat, boolean locally)
		throws RemoteException {
	    Log.i("LOG", "chatCreated");
	    
	}
	
    }
    
    private class OnMessageListener extends IMessageListener.Stub {

	@Override
	public void processMessage(IChat chat, Message msg)
		throws RemoteException {
	    Log.i("LOG", "processMessage");
	    mAdapter.add(mContact.getJID() + " "
		    + getString(R.string.SendIMSays) + msg.getBody());
	}
	
    }
}
