/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.utils.base64;

public class IPSECKEYRecord
extends Record {
    private static final long serialVersionUID = 3050449702765909687L;
    private int precedence;
    private int gatewayType;
    private int algorithmType;
    private Object gateway;
    private byte[] key;

    IPSECKEYRecord() {
    }

    Record getObject() {
        return new IPSECKEYRecord();
    }

    public IPSECKEYRecord(Name name, int n, long l, int n2, int n3, int n4, Object object, byte[] byArray) {
        super(name, 45, n, l);
        this.precedence = IPSECKEYRecord.checkU8("precedence", n2);
        this.gatewayType = IPSECKEYRecord.checkU8("gatewayType", n3);
        this.algorithmType = IPSECKEYRecord.checkU8("algorithmType", n4);
        switch (n3) {
            case 0: {
                this.gateway = null;
                break;
            }
            case 1: {
                if (!(object instanceof InetAddress)) {
                    throw new IllegalArgumentException("\"gateway\" must be an IPv4 address");
                }
                this.gateway = object;
                break;
            }
            case 2: {
                if (!(object instanceof Inet6Address)) {
                    throw new IllegalArgumentException("\"gateway\" must be an IPv6 address");
                }
                this.gateway = object;
                break;
            }
            case 3: {
                if (!(object instanceof Name)) {
                    throw new IllegalArgumentException("\"gateway\" must be a DNS name");
                }
                this.gateway = IPSECKEYRecord.checkName("gateway", (Name)object);
                break;
            }
            default: {
                throw new IllegalArgumentException("\"gatewayType\" must be between 0 and 3");
            }
        }
        this.key = byArray;
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.precedence = dNSInput.readU8();
        this.gatewayType = dNSInput.readU8();
        this.algorithmType = dNSInput.readU8();
        switch (this.gatewayType) {
            case 0: {
                this.gateway = null;
                break;
            }
            case 1: {
                this.gateway = InetAddress.getByAddress(dNSInput.readByteArray(4));
                break;
            }
            case 2: {
                this.gateway = InetAddress.getByAddress(dNSInput.readByteArray(16));
                break;
            }
            case 3: {
                this.gateway = new Name(dNSInput);
                break;
            }
            default: {
                throw new WireParseException("invalid gateway type");
            }
        }
        if (dNSInput.remaining() > 0) {
            this.key = dNSInput.readByteArray();
        }
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        this.precedence = tokenizer.getUInt8();
        this.gatewayType = tokenizer.getUInt8();
        this.algorithmType = tokenizer.getUInt8();
        switch (this.gatewayType) {
            case 0: {
                String string = tokenizer.getString();
                if (!string.equals(".")) {
                    throw new TextParseException("invalid gateway format");
                }
                this.gateway = null;
                break;
            }
            case 1: {
                this.gateway = tokenizer.getAddress(1);
                break;
            }
            case 2: {
                this.gateway = tokenizer.getAddress(2);
                break;
            }
            case 3: {
                this.gateway = tokenizer.getName(name);
                break;
            }
            default: {
                throw new WireParseException("invalid gateway type");
            }
        }
        this.key = tokenizer.getBase64(false);
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.precedence);
        stringBuffer.append(" ");
        stringBuffer.append(this.gatewayType);
        stringBuffer.append(" ");
        stringBuffer.append(this.algorithmType);
        stringBuffer.append(" ");
        switch (this.gatewayType) {
            case 0: {
                stringBuffer.append(".");
                break;
            }
            case 1: 
            case 2: {
                InetAddress inetAddress = (InetAddress)this.gateway;
                stringBuffer.append(inetAddress.getHostAddress());
                break;
            }
            case 3: {
                stringBuffer.append(this.gateway);
            }
        }
        if (this.key != null) {
            stringBuffer.append(" ");
            stringBuffer.append(base64.toString(this.key));
        }
        return stringBuffer.toString();
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public int getGatewayType() {
        return this.gatewayType;
    }

    public int getAlgorithmType() {
        return this.algorithmType;
    }

    public Object getGateway() {
        return this.gateway;
    }

    public byte[] getKey() {
        return this.key;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU8(this.precedence);
        dNSOutput.writeU8(this.gatewayType);
        dNSOutput.writeU8(this.algorithmType);
        switch (this.gatewayType) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                InetAddress inetAddress = (InetAddress)this.gateway;
                dNSOutput.writeByteArray(inetAddress.getAddress());
                break;
            }
            case 3: {
                Name name = (Name)this.gateway;
                name.toWire(dNSOutput, null, bl);
            }
        }
        if (this.key != null) {
            dNSOutput.writeByteArray(this.key);
        }
    }

    public static class Gateway {
        public static final int None = 0;
        public static final int IPv4 = 1;
        public static final int IPv6 = 2;
        public static final int Name = 3;

        private Gateway() {
        }
    }

    public static class Algorithm {
        public static final int DSA = 1;
        public static final int RSA = 2;

        private Algorithm() {
        }
    }
}

