/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.provider;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.commands.AdHocCommandNote;
import org.jivesoftware.smackx.packet.AdHocCommandData;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.provider.DataFormProvider;
import org.xmlpull.v1.XmlPullParser;

public class AdHocCommandDataProvider
implements IQProvider {
    public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
        Object object;
        boolean bl = false;
        AdHocCommandData adHocCommandData = new AdHocCommandData();
        DataFormProvider dataFormProvider = new DataFormProvider();
        adHocCommandData.setSessionID(xmlPullParser.getAttributeValue("", "sessionid"));
        adHocCommandData.setNode(xmlPullParser.getAttributeValue("", "node"));
        String string = xmlPullParser.getAttributeValue("", "status");
        if (AdHocCommand.Status.executing.toString().equalsIgnoreCase(string)) {
            adHocCommandData.setStatus(AdHocCommand.Status.executing);
        } else if (AdHocCommand.Status.completed.toString().equalsIgnoreCase(string)) {
            adHocCommandData.setStatus(AdHocCommand.Status.completed);
        } else if (AdHocCommand.Status.canceled.toString().equalsIgnoreCase(string)) {
            adHocCommandData.setStatus(AdHocCommand.Status.canceled);
        }
        String string2 = xmlPullParser.getAttributeValue("", "action");
        if (string2 != null) {
            object = AdHocCommand.Action.valueOf(string2);
            if (object == null || object.equals((Object)AdHocCommand.Action.unknown)) {
                adHocCommandData.setAction(AdHocCommand.Action.unknown);
            } else {
                adHocCommandData.setAction((AdHocCommand.Action)((Object)object));
            }
        }
        while (!bl) {
            int n = xmlPullParser.next();
            String string3 = xmlPullParser.getName();
            String string4 = xmlPullParser.getNamespace();
            if (n == 2) {
                if (xmlPullParser.getName().equals("actions")) {
                    object = xmlPullParser.getAttributeValue("", "execute");
                    if (object == null) continue;
                    adHocCommandData.setExecuteAction(AdHocCommand.Action.valueOf((String)object));
                    continue;
                }
                if (xmlPullParser.getName().equals("next")) {
                    adHocCommandData.addAction(AdHocCommand.Action.next);
                    continue;
                }
                if (xmlPullParser.getName().equals("complete")) {
                    adHocCommandData.addAction(AdHocCommand.Action.complete);
                    continue;
                }
                if (xmlPullParser.getName().equals("prev")) {
                    adHocCommandData.addAction(AdHocCommand.Action.prev);
                    continue;
                }
                if (string3.equals("x") && string4.equals("jabber:x:data")) {
                    adHocCommandData.setForm((DataForm)dataFormProvider.parseExtension(xmlPullParser));
                    continue;
                }
                if (xmlPullParser.getName().equals("note")) {
                    object = AdHocCommandNote.Type.valueOf(xmlPullParser.getAttributeValue("", "type"));
                    String string5 = xmlPullParser.nextText();
                    adHocCommandData.addNote(new AdHocCommandNote((AdHocCommandNote.Type)((Object)object), string5));
                    continue;
                }
                if (!xmlPullParser.getName().equals("error")) continue;
                object = PacketParserUtils.parseError(xmlPullParser);
                adHocCommandData.setError((XMPPError)object);
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("command")) continue;
            bl = true;
        }
        return adHocCommandData;
    }

    public static class SessionExpiredError
    implements PacketExtensionProvider {
        public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
            return new AdHocCommandData.SpecificError(AdHocCommand.SpecificErrorCondition.sessionExpired);
        }
    }

    public static class BadSessionIDError
    implements PacketExtensionProvider {
        public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
            return new AdHocCommandData.SpecificError(AdHocCommand.SpecificErrorCondition.badSessionid);
        }
    }

    public static class BadPayloadError
    implements PacketExtensionProvider {
        public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
            return new AdHocCommandData.SpecificError(AdHocCommand.SpecificErrorCondition.badPayload);
        }
    }

    public static class BadLocaleError
    implements PacketExtensionProvider {
        public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
            return new AdHocCommandData.SpecificError(AdHocCommand.SpecificErrorCondition.badLocale);
        }
    }

    public static class MalformedActionError
    implements PacketExtensionProvider {
        public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
            return new AdHocCommandData.SpecificError(AdHocCommand.SpecificErrorCondition.malformedAction);
        }
    }

    public static class BadActionError
    implements PacketExtensionProvider {
        public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
            return new AdHocCommandData.SpecificError(AdHocCommand.SpecificErrorCondition.badAction);
        }
    }
}

