/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.PacketMultiplexListener;

class RoomListenerMultiplexor
implements ConnectionListener {
    private static final Map<XMPPConnection, WeakReference<RoomListenerMultiplexor>> monitors = new WeakHashMap<XMPPConnection, WeakReference<RoomListenerMultiplexor>>();
    private XMPPConnection connection;
    private RoomMultiplexFilter filter;
    private RoomMultiplexListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoomListenerMultiplexor getRoomMultiplexor(XMPPConnection xMPPConnection) {
        Map<XMPPConnection, WeakReference<RoomListenerMultiplexor>> map = monitors;
        synchronized (map) {
            if (!monitors.containsKey(xMPPConnection)) {
                RoomListenerMultiplexor roomListenerMultiplexor = new RoomListenerMultiplexor(xMPPConnection, new RoomMultiplexFilter(), new RoomMultiplexListener());
                roomListenerMultiplexor.init();
                monitors.put(xMPPConnection, new WeakReference<RoomListenerMultiplexor>(roomListenerMultiplexor));
            }
            return (RoomListenerMultiplexor)monitors.get(xMPPConnection).get();
        }
    }

    private RoomListenerMultiplexor(XMPPConnection xMPPConnection, RoomMultiplexFilter roomMultiplexFilter, RoomMultiplexListener roomMultiplexListener) {
        if (xMPPConnection == null) {
            throw new IllegalArgumentException("Connection is null");
        }
        if (roomMultiplexFilter == null) {
            throw new IllegalArgumentException("Filter is null");
        }
        if (roomMultiplexListener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        this.connection = xMPPConnection;
        this.filter = roomMultiplexFilter;
        this.listener = roomMultiplexListener;
    }

    public void addRoom(String string, PacketMultiplexListener packetMultiplexListener) {
        this.filter.addRoom(string);
        this.listener.addRoom(string, packetMultiplexListener);
    }

    public void connectionClosed() {
        this.cancel();
    }

    public void connectionClosedOnError(Exception exception) {
        this.cancel();
    }

    public void reconnectingIn(int n) {
    }

    public void reconnectionSuccessful() {
    }

    public void reconnectionFailed(Exception exception) {
    }

    public void init() {
        this.connection.addConnectionListener(this);
        this.connection.addPacketListener(this.listener, this.filter);
    }

    public void removeRoom(String string) {
        this.filter.removeRoom(string);
        this.listener.removeRoom(string);
    }

    private void cancel() {
        this.connection.removeConnectionListener(this);
        this.connection.removePacketListener(this.listener);
    }

    private static class RoomMultiplexListener
    implements PacketListener {
        private Map<String, PacketMultiplexListener> roomListenersByAddress = new ConcurrentHashMap<String, PacketMultiplexListener>();

        private RoomMultiplexListener() {
        }

        public void processPacket(Packet packet) {
            String string = packet.getFrom();
            if (string == null) {
                return;
            }
            PacketMultiplexListener packetMultiplexListener = this.roomListenersByAddress.get(StringUtils.parseBareAddress(string).toLowerCase());
            if (packetMultiplexListener != null) {
                packetMultiplexListener.processPacket(packet);
            }
        }

        public void addRoom(String string, PacketMultiplexListener packetMultiplexListener) {
            if (string == null) {
                return;
            }
            this.roomListenersByAddress.put(string.toLowerCase(), packetMultiplexListener);
        }

        public void removeRoom(String string) {
            if (string == null) {
                return;
            }
            this.roomListenersByAddress.remove(string.toLowerCase());
        }
    }

    private static class RoomMultiplexFilter
    implements PacketFilter {
        private Map<String, String> roomAddressTable = new ConcurrentHashMap<String, String>();

        private RoomMultiplexFilter() {
        }

        public boolean accept(Packet packet) {
            String string = packet.getFrom();
            if (string == null) {
                return false;
            }
            return this.roomAddressTable.containsKey(StringUtils.parseBareAddress(string).toLowerCase());
        }

        public void addRoom(String string) {
            if (string == null) {
                return;
            }
            this.roomAddressTable.put(string.toLowerCase(), string);
        }

        public void removeRoom(String string) {
            if (string == null) {
                return;
            }
            this.roomAddressTable.remove(string.toLowerCase());
        }
    }
}

