package com.beem.project.beem.service;

import java.util.ArrayList;
import java.util.List;

import org.jivesoftware.smack.PrivacyListListener;
import org.jivesoftware.smack.PrivacyListManager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.PrivacyItem;
import org.jivesoftware.smack.packet.PrivacyItem.PrivacyRule;

import android.os.RemoteException;
import android.util.Log;

import com.beem.project.beem.service.aidl.IPrivacyListManager;

/**
 * Privacy list manager in beem.
 * @author nikita
 */
public class PrivacyListManagerAdapter extends IPrivacyListManager.Stub {

    /**
     * Tag.
     */
    public static final String TAG = "PrivacyListManagerAdapter";
    /**
     * default privacy list name.
     */
    public static final String DEFAULT_PRIVACYLIST = "default";

    private PrivacyListManager mAdaptee;
    private List<String> mBlockedUser = new ArrayList<String>();
    private XMPPConnection mConnection;
    private MyPrivacyListListener mPrivacyPacketListener = new MyPrivacyListListener();

    /**
     * Privacy list constructor.
     * @param connection xmppconnection used.
     */
    public PrivacyListManagerAdapter(final XMPPConnection connection) {
	mConnection = connection;
	mAdaptee = PrivacyListManager.getInstanceFor(mConnection);
	mAdaptee.addListener(mPrivacyPacketListener);
    }

    /**
     * return the blocked user list.
     * @return blocked user list
     */
    public List<String> getBlockedUsers() {
	return mBlockedUser;
    }

    /**
     * add an user to the blocked user list.
     * @param jid blocked user jid
     */
    public synchronized void addBlockedUser(final String jid) {
	if (mAdaptee == null) {
	    mAdaptee = PrivacyListManager.getInstanceFor(mConnection);
	    mAdaptee.addListener(mPrivacyPacketListener);
	}
	List<PrivacyItem> pItemList = new ArrayList<PrivacyItem>();
	PrivacyItem pItem = new PrivacyItem("jid", true, 1);
	pItem.setFilterMessage(true);
	pItem.setValue(jid);
	pItemList.add(pItem);

	pItem = new PrivacyItem("subscription", true, 2);
	pItem.setValue(PrivacyRule.SUBSCRIPTION_BOTH);
	pItemList.add(pItem);

	try {
	    if (mAdaptee.getPrivacyList(DEFAULT_PRIVACYLIST) == null) {
		mAdaptee.createPrivacyList(DEFAULT_PRIVACYLIST, pItemList);
	    }

	} catch (XMPPException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	} catch (ClassCastException e) {
	    e.printStackTrace();
	    try {
		mAdaptee.createPrivacyList(DEFAULT_PRIVACYLIST, pItemList);
	    } catch (XMPPException e1) {
		// TODO Auto-generated catch block
		e1.printStackTrace();
	    }
	}
	try {
	    mAdaptee.setActiveListName(DEFAULT_PRIVACYLIST);
	    mAdaptee.setDefaultListName(DEFAULT_PRIVACYLIST);
	} catch (XMPPException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	}

	Log.d(TAG, "addBlockedUser");
    }

    /**
     * privacy list listener.
     * @author nikita
     */
    class MyPrivacyListListener implements PrivacyListListener {
	/**
	 * constructor.
	 */
	public MyPrivacyListListener() {
	}

	@Override
	public void setPrivacyList(String listName, List<PrivacyItem> listItem) {
	    Log.d(TAG, "setPrivacyList");
	}

	@Override
	public void updatedPrivacyList(String listName) {
	    Log.d(TAG, "updatedPrivacyList");
	}
    }

    @Override
    public List<String> getBlockedUsersByList(String listName) throws RemoteException {
	// TODO Auto-generated method stub
	return null;
    }

    /**
     * adaptee getter.
     * @return the current PrivacyListManager instance
     */
    public PrivacyListManager getManager() {
	return mAdaptee;
    }
}
