/**
 * 
 */
package com.beem.project.beem.service;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * @author darisk
 *
 */
public class Message implements Parcelable {
    
    public final static int MSG_TYPE_NORMAL = 100;
    public final static int MSG_TYPE_CHAT = 200;
    public final static int MSG_TYPE_GROUP_CHAT = 300;
    
    private int mType;
    private String mBody;
    private String mSubject;
    private String mTo;
    private String mThread;

    /**
     * Parcelable.Creator needs by Android.
     */
    public static final Parcelable.Creator<Message> CREATOR = new Parcelable.Creator<Message>() {

	@Override
	public Message createFromParcel(Parcel source) {
	    return new Message(source);
	}

	@Override
	public Message[] newArray(int size) {
	    return new Message[size];
	}
    };
    
    public Message(String to, int type) {
	mTo = to;
	mType = type;
	mBody = "";
	mSubject = "";
	mThread = "";
    }
    
    public Message(String to) {
	this(to, MSG_TYPE_CHAT);
    }
    
    /**
     * Construct a message from a parcel.
     * @param in parcel to use for construction
     */
    private Message(final Parcel in) {
	mType = in.readInt();
	mTo = in.readString();
	mBody = in.readString();
	mSubject = in.readString();
	mThread = in.readString();
    }
    
    @Override
    public void writeToParcel(Parcel dest, int flags) {
	// TODO Auto-generated method stub
	dest.writeInt(mType);
	dest.writeString(mTo);
	dest.writeString(mBody);
	dest.writeString(mSubject);
	dest.writeString(mThread);
    }
    
    /**
     * @return the Type
     */
    public int getType() {
        return mType;
    }

    /**
     * @param type the Type to set
     */
    public void setType(int type) {
        mType = type;
    }


    /**
     * @return the mBody
     */
    public String getBody() {
        return mBody;
    }


    /**
     * @param body the mBody to set
     */
    public void setBody(String body) {
        mBody = body;
    }


    /**
     * @return the mSubject
     */
    public String getSubject() {
        return mSubject;
    }


    /**
     * @param subject the mSubject to set
     */
    public void setSubject(String subject) {
        mSubject = subject;
    }


    /**
     * @return the mTo
     */
    public String getTo() {
        return mTo;
    }


    /**
     * @param to the mTo to set
     */
    public void setTo(String to) {
        mTo = to;
    }


    /**
     * @return the mThread
     */
    public String getThread() {
        return mThread;
    }


    /**
     * @param thread the mThread to set
     */
    public void setThread(String thread) {
        mThread = thread;
    }


    @Override
    public int describeContents() {
	// TODO Auto-generated method stub
	return 0;
    }


 

    
    
}
