/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;

public class SmackLogger {
    private Log commonsLogger;

    public static SmackLogger getLogger(Class classToLog) {
        return new SmackLogger(classToLog);
    }

    public SmackLogger(Class classToLog) {
        this.setupSmackLogger(classToLog);
    }

    private void setupSmackLogger(Class classToLog) {
        try {
            Class<?> logFactoryClass = SmackLogger.class.getClassLoader().loadClass("org.apache.commons.logging.LogFactory");
            Method method = logFactoryClass.getMethod("getLog", Class.class);
            this.commonsLogger = (Log)method.invoke(null, classToLog);
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void error(String inErrorMsg, Exception inException) {
        if (this.commonsLogger != null) {
            this.commonsLogger.error((Object)inErrorMsg, (Throwable)inException);
        } else {
            System.err.println(inErrorMsg);
            inException.printStackTrace(System.err);
        }
    }

    public void error(String inErrorMsg) {
        if (this.commonsLogger != null) {
            this.commonsLogger.error((Object)inErrorMsg);
        } else {
            System.err.println(inErrorMsg);
        }
    }

    public void debug(String inDebugMsg, Exception inException) {
        if (this.commonsLogger != null) {
            this.commonsLogger.debug((Object)inDebugMsg, (Throwable)inException);
        } else {
            System.out.println(inDebugMsg);
            inException.printStackTrace(System.out);
        }
    }

    public void debug(String inDebugMsg) {
        if (this.commonsLogger != null) {
            this.commonsLogger.debug((Object)inDebugMsg);
        } else {
            System.out.println(inDebugMsg);
        }
    }

    public void warn(String inDebugMsg, Exception inException) {
        if (this.commonsLogger != null) {
            this.commonsLogger.warn((Object)inDebugMsg, (Throwable)inException);
        } else {
            System.out.println(inDebugMsg);
            inException.printStackTrace(System.out);
        }
    }

    public void warn(String inDebugMsg) {
        if (this.commonsLogger != null) {
            this.commonsLogger.warn((Object)inDebugMsg);
        } else {
            System.out.println(inDebugMsg);
        }
    }

    public void info(String inDebugMsg, Exception inException) {
        if (this.commonsLogger != null) {
            this.commonsLogger.info((Object)inDebugMsg, (Throwable)inException);
        } else {
            System.out.println(inDebugMsg);
            inException.printStackTrace(System.out);
        }
    }

    public void info(String inDebugMsg) {
        if (this.commonsLogger != null) {
            this.commonsLogger.info((Object)inDebugMsg);
        } else {
            System.out.println(inDebugMsg);
        }
    }
}

