/*
 * Decompiled with CFR 0.152.
 */
package org.umlgraph.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import com.sun.tools.javadoc.Main;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.umlgraph.doclet.ClassGraph;
import org.umlgraph.doclet.OptionProvider;
import org.umlgraph.doclet.Options;
import org.umlgraph.doclet.Shape;
import org.umlgraph.doclet.Version;
import org.umlgraph.doclet.View;

public class UmlGraph {
    private static final String programName = "UmlGraph";
    private static final String docletName = "org.umlgraph.doclet.UmlGraph";
    private static Options commentOptions;

    public static boolean start(RootDoc root) throws IOException {
        Options opt = UmlGraph.buildOptions(root);
        root.printNotice("UMLGraph doclet version " + Version.VERSION + " started");
        View[] views = UmlGraph.buildViews(opt, root, root);
        if (views == null) {
            return false;
        }
        if (views.length == 0) {
            UmlGraph.buildGraph(root, opt, null);
        } else {
            for (int i = 0; i < views.length; ++i) {
                UmlGraph.buildGraph(root, views[i], null);
            }
        }
        return true;
    }

    public static void main(String[] args) {
        PrintWriter err = new PrintWriter(System.err);
        Main.execute((String)programName, (PrintWriter)err, (PrintWriter)err, (PrintWriter)err, (String)docletName, (String[])args);
    }

    public static Options getCommentOptions() {
        return commentOptions;
    }

    public static Options buildOptions(RootDoc root) {
        commentOptions = new Options();
        commentOptions.setOptions(root.options());
        commentOptions.setOptions(UmlGraph.findClass(root, "UMLNoteOptions"));
        UmlGraph.commentOptions.shape = new Shape("note");
        Options opt = new Options();
        opt.setOptions(root.options());
        opt.setOptions(UmlGraph.findClass(root, "UMLOptions"));
        return opt;
    }

    private static ClassDoc findClass(RootDoc root, String name) {
        ClassDoc[] classes;
        for (ClassDoc cd : classes = root.classes()) {
            if (!cd.name().equals(name)) continue;
            return cd;
        }
        return null;
    }

    public static void buildGraph(RootDoc root, OptionProvider op, Doc contextDoc) throws IOException {
        int i;
        if (UmlGraph.getCommentOptions() == null) {
            UmlGraph.buildOptions(root);
        }
        Options opt = op.getGlobalOptions();
        root.printNotice("Building " + op.getDisplayName());
        ClassDoc[] classes = root.classes();
        ClassGraph c = new ClassGraph(root, op, contextDoc);
        c.prologue();
        for (i = 0; i < classes.length; ++i) {
            c.printClass(classes[i], true);
        }
        for (i = 0; i < classes.length; ++i) {
            c.printRelations(classes[i]);
        }
        if (opt.inferRelationships) {
            c.printInferredRelations(classes);
        }
        if (opt.inferDependencies) {
            c.printInferredDependencies(classes);
        }
        c.printExtraClasses(root);
        c.epilogue();
    }

    public static View[] buildViews(Options opt, RootDoc srcRootDoc, RootDoc viewRootDoc) {
        if (opt.viewName != null) {
            ClassDoc viewClass = viewRootDoc.classNamed(opt.viewName);
            if (viewClass == null) {
                System.out.println("View " + opt.viewName + " not found! Exiting without generating any output.");
                return null;
            }
            if (viewClass.tags("view").length == 0) {
                System.out.println(viewClass + " is not a view!");
                return null;
            }
            if (viewClass.isAbstract()) {
                System.out.println(viewClass + " is an abstract view, no output will be generated!");
                return null;
            }
            return new View[]{UmlGraph.buildView(srcRootDoc, viewClass, opt)};
        }
        if (opt.findViews) {
            ArrayList<View> views = new ArrayList<View>();
            ClassDoc[] classes = viewRootDoc.classes();
            for (int i = 0; i < classes.length; ++i) {
                if (classes[i].tags("view").length <= 0 || classes[i].isAbstract()) continue;
                views.add(UmlGraph.buildView(srcRootDoc, classes[i], opt));
            }
            return views.toArray(new View[views.size()]);
        }
        return new View[0];
    }

    private static View buildView(RootDoc root, ClassDoc viewClass, OptionProvider provider) {
        ClassDoc superClass = viewClass.superclass();
        if (superClass == null || superClass.tags("view").length == 0) {
            return new View(root, viewClass, provider);
        }
        return new View(root, viewClass, UmlGraph.buildView(root, superClass, provider));
    }

    public static int optionLength(String option) {
        return Options.optionLength(option);
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }
}

