/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth.callback;

import java.io.Serializable;
import org.apache.harmony.javax.security.auth.callback.Callback;

public class ConfirmationCallback
implements Callback,
Serializable {
    private static final long serialVersionUID = -9095656433782481624L;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    public static final int OK = 3;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int UNSPECIFIED_OPTION = -1;
    public static final int INFORMATION = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private String prompt;
    private int messageType;
    private int optionType = -1;
    private int defaultOption;
    private String[] options;
    private int selection;

    public ConfirmationCallback(int n, int n2, int n3) {
        if (n > 2 || n < 0) {
            throw new IllegalArgumentException("auth.16");
        }
        switch (n2) {
            case 0: {
                if (n3 == 0 || n3 == 1) break;
                throw new IllegalArgumentException("auth.17");
            }
            case 1: {
                if (n3 == 0 || n3 == 1 || n3 == 2) break;
                throw new IllegalArgumentException("auth.17");
            }
            case 2: {
                if (n3 == 3 || n3 == 2) break;
                throw new IllegalArgumentException("auth.17");
            }
            default: {
                throw new IllegalArgumentException("auth.18");
            }
        }
        this.messageType = n;
        this.optionType = n2;
        this.defaultOption = n3;
    }

    public ConfirmationCallback(int n, String[] stringArray, int n2) {
        if (n > 2 || n < 0) {
            throw new IllegalArgumentException("auth.16");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("auth.1A");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null && stringArray[i].length() != 0) continue;
            throw new IllegalArgumentException("auth.1A");
        }
        if (0 > n2 || n2 >= stringArray.length) {
            throw new IllegalArgumentException("auth.17");
        }
        this.options = stringArray;
        this.defaultOption = n2;
        this.messageType = n;
    }

    public ConfirmationCallback(String string, int n, int n2, int n3) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("auth.14");
        }
        if (n > 2 || n < 0) {
            throw new IllegalArgumentException("auth.16");
        }
        switch (n2) {
            case 0: {
                if (n3 == 0 || n3 == 1) break;
                throw new IllegalArgumentException("auth.17");
            }
            case 1: {
                if (n3 == 0 || n3 == 1 || n3 == 2) break;
                throw new IllegalArgumentException("auth.17");
            }
            case 2: {
                if (n3 == 3 || n3 == 2) break;
                throw new IllegalArgumentException("auth.17");
            }
            default: {
                throw new IllegalArgumentException("auth.18");
            }
        }
        this.prompt = string;
        this.messageType = n;
        this.optionType = n2;
        this.defaultOption = n3;
    }

    public ConfirmationCallback(String string, int n, String[] stringArray, int n2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("auth.14");
        }
        if (n > 2 || n < 0) {
            throw new IllegalArgumentException("auth.16");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("auth.1A");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null && stringArray[i].length() != 0) continue;
            throw new IllegalArgumentException("auth.1A");
        }
        if (0 > n2 || n2 >= stringArray.length) {
            throw new IllegalArgumentException("auth.17");
        }
        this.options = stringArray;
        this.defaultOption = n2;
        this.messageType = n;
        this.prompt = string;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public int getDefaultOption() {
        return this.defaultOption;
    }

    public String[] getOptions() {
        return this.options;
    }

    public int getOptionType() {
        return this.optionType;
    }

    public int getSelectedIndex() {
        return this.selection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSelectedIndex(int n) {
        if (this.options != null) {
            if (0 > n || n > this.options.length) throw new ArrayIndexOutOfBoundsException("auth.1B");
            this.selection = n;
            return;
        } else {
            switch (this.optionType) {
                case 0: {
                    if (n == 0 || n == 1) break;
                    throw new IllegalArgumentException("auth.19");
                }
                case 1: {
                    if (n == 0 || n == 1 || n == 2) break;
                    throw new IllegalArgumentException("auth.19");
                }
                case 2: {
                    if (n == 3 || n == 2) break;
                    throw new IllegalArgumentException("auth.19");
                }
            }
            this.selection = n;
        }
    }
}

