package com.beem.project.beem;

import android.app.Dialog;
import android.content.SharedPreferences;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

/**
 *
 */
public class SettingsDialog extends Dialog implements android.view.View.OnClickListener {

    private Beem mbeem;
    private SharedPreferences mSettings;
    public SettingsDialog(Beem beem, SharedPreferences settings) {
        super(beem);
        this.mbeem = beem;
        this.mSettings = settings;
    }

    protected void onStart() {
        super.onStart();
        setContentView(R.layout.settings);
        getWindow().setFlags(4, 4);
        setTitle("Jabber Account Settings");
        showSettings();
        Button ok = (Button) findViewById(R.id.ok);
        ok.setOnClickListener(this);
    }
    
    public void onClick(View v) {
        SharedPreferences.Editor editor = mSettings.edit();
        editor.putString("host", getText(R.id.host));
        editor.putString("port", getText(R.id.port));
        editor.putString("login", getText(R.id.userid));
        editor.putString("password", getText(R.id.password));
        editor.commit();
        
        this.mbeem.showJID();
        dismiss();
    }
    
    private void showSettings() {
        String tmp;
        EditText eHost = (EditText) findViewById(R.id.host);
        if ((tmp = mSettings.getString("host","")) != "")
            eHost.setText(tmp);
        EditText ePort = (EditText) findViewById(R.id.port);
        if ((tmp = mSettings.getString("port","")) != "")
            ePort.setText(tmp);
        EditText eLogin = (EditText) findViewById(R.id.userid);
        if ((tmp = mSettings.getString("login","")) != "")
            eLogin.setText(tmp);
        EditText ePwd = (EditText) findViewById(R.id.password);
        if ((tmp = mSettings.getString("password","")) != "")
            ePwd.setText(tmp);
    }
    
    private String getText(int id) {
        EditText widget = (EditText) this.findViewById(id);
        return widget.getText().toString();
    }
}
