/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingle.JingleNegotiatorState;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.listeners.JingleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JingleNegotiator {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(JingleNegotiator.class);
    protected JingleSession session;
    private final List<JingleListener> listeners = new ArrayList<JingleListener>();
    private String expectedAckId;
    private JingleNegotiatorState state;
    private boolean isStarted;

    public JingleNegotiator() {
        this(null);
    }

    public JingleNegotiator(JingleSession session) {
        this.session = session;
        this.state = JingleNegotiatorState.PENDING;
    }

    public JingleNegotiatorState getNegotiatorState() {
        return this.state;
    }

    public void setNegotiatorState(JingleNegotiatorState stateIs) {
        JingleNegotiatorState stateWas = this.state;
        LOGGER.debug("Negotiator state change: " + (Object)((Object)stateWas) + "->" + (Object)((Object)stateIs) + "(" + this.getClass().getSimpleName() + ")");
        switch (stateIs) {
            case PENDING: {
                break;
            }
            case FAILED: {
                break;
            }
            case SUCCEEDED: {
                break;
            }
        }
        this.state = stateIs;
    }

    public XMPPConnection getConnection() {
        if (this.session != null) {
            return this.session.getConnection();
        }
        return null;
    }

    public JingleSession getSession() {
        return this.session;
    }

    public void setSession(JingleSession session) {
        this.session = session;
    }

    public void addExpectedId(String id) {
        this.expectedAckId = id;
    }

    public boolean isExpectedId(String id) {
        if (id != null) {
            return id.equals(this.expectedAckId);
        }
        return false;
    }

    public void removeExpectedId(String id) {
        this.addExpectedId(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(JingleListener li) {
        List<JingleListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(li);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(JingleListener li) {
        List<JingleListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(li);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<JingleListener> getListenersList() {
        ArrayList<JingleListener> result;
        List<JingleListener> list = this.listeners;
        synchronized (list) {
            result = new ArrayList<JingleListener>(this.listeners);
        }
        return result;
    }

    public abstract List<IQ> dispatchIncomingPacket(IQ var1, String var2) throws XMPPException;

    public void start() {
        this.isStarted = true;
        this.doStart();
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    protected abstract void doStart();

    public void close() {
    }
}

