package com.beem.project.beem.service;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Intent;
import android.os.RemoteException;
import com.beem.project.beem.BeemService;
import com.beem.project.beem.service.aidl.IChatManager;
import com.beem.project.beem.service.aidl.IRoster;
import com.beem.project.beem.service.aidl.IXmppConnection;
import com.beem.project.beem.service.aidl.IXmppFacade;

/**
 * This class is a facade for the Beem Service.
 * @author darisk
 */
public class XmppFacade extends IXmppFacade.Stub {

    private IXmppConnection mConnexion;
    private BeemService mBeemService;

    /**
     * Constructor for XMPPFacade.
     * @param connection the connection use by the facade
     * @param service the service which holds the facade
     */
    public XmppFacade(final IXmppConnection connection, final BeemService service) {
	this.mConnexion = connection;
	this.mBeemService = service;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void connectAsync() throws RemoteException {
	mConnexion.connectAsync();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void connectSync() throws RemoteException {
	mConnexion.connectSync();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IXmppConnection createConnection() throws RemoteException {
	return mConnexion;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void disconnect() throws RemoteException {
	mConnexion.disconnect();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IRoster getRoster() throws RemoteException {
	return mConnexion.getRoster();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IChatManager getChatManager() throws RemoteException {
	return mConnexion.getChatManager();
    }

    /**
     * {@inheritDoc}
     */
    public void changeStatus() {
	Notification mStatusNotification;
	String text = "Salut les amirs !!!!";
	mStatusNotification = new Notification(com.beem.project.beem.R.drawable.logo, text, System.currentTimeMillis());
	mStatusNotification.defaults = Notification.DEFAULT_ALL;
	mStatusNotification.flags = Notification.FLAG_NO_CLEAR;

	// TODO
	// mStatusNotification.contentView = ;
	mStatusNotification.setLatestEventInfo(mBeemService, "Beem Status", text, PendingIntent.getActivity(
	    mBeemService, 0, new Intent(), 0));
	mBeemService.sendNotification(BeemService.NOTIFICATION_STATUS_ID, mStatusNotification);
    }
}
