package com.beem.project.beem.provider;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

public class BeemDatabaseHelper extends SQLiteOpenHelper {
	
	private String tag;
	private String tableName;
	private String creationQuery;

	public BeemDatabaseHelper(Context context, String tag, String tableName, String creationQuery) {
		super(context, Beem.DB_NAME, null, Beem.DB_VERSION);
		
		this.tag = tag;
		this.tableName = tableName;
		this.creationQuery = creationQuery;
	}
	
	@Override
	public void onCreate(SQLiteDatabase db) {
		db.execSQL(this.creationQuery);
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		Log.w(this.tag, "Upgrading database from version " + oldVersion + " to "
				+ newVersion + ", which will destroy all old data");
		db.execSQL("DROP TABLE IF EXISTS " + this.tableName + ";");
		onCreate(db);
	}
}
