/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/

    Epitech, hereby disclaims all copyright interest in the program "Beem"
    written by Frederic-Charles Barthelery,
               Jean-Manuel Da Silva,
               Nikita Kozlov,
               Philippe Lago,
               Jean Baptiste Vergely,
               Vincent Veronis.

    Nicolas Sadirac, November 26, 2009
    President of Epitech.

    Flavien Astraud, November 26, 2009
    Head of the EIP Laboratory.

*/
package com.beem.project.beem.utils;

import org.jivesoftware.smack.util.StringUtils;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.widget.Toast;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.util.Log;


import com.beem.project.beem.BeemApplication;
import com.beem.project.beem.BeemIntent;
import com.beem.project.beem.BeemService;
import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;
import com.beem.project.beem.service.Message;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.net.Uri;

/**
 * Manage broadcast disconnect intent.
 * @author nikita
 */
public class BeemBroadcastReceiver extends BroadcastReceiver {

    /** Broadcast intent type. */
    public static final String BEEM_CONNECTION_CLOSED = "BeemConnectionClosed";

    /**
     * constructor.
     */
    public BeemBroadcastReceiver() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onReceive(final Context context, final Intent intent) {
	String intentAction = intent.getAction();
	if (intentAction.equals(BEEM_CONNECTION_CLOSED)) {
	    CharSequence message = intent.getCharSequenceExtra("message");
	    Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
	    if (context instanceof Activity) {
		Activity act = (Activity) context;
		act.finish();
		// The service will be unbinded in the destroy of the activity.
	    }
	} else if (intentAction.equals(ConnectivityManager.CONNECTIVITY_ACTION)) {
	    if (intent.getBooleanExtra(ConnectivityManager.EXTRA_NO_CONNECTIVITY, false)) {
		Toast.makeText(context, context.getString(R.string.BeemBroadcastReceiverDisconnect),
		    Toast.LENGTH_SHORT).show();
		context.stopService(new Intent(context, BeemService.class));
	    }
	} else if (intentAction.equals(BeemIntent.ACTION_MESSAGE_RECEIVED)) {
	    Message msg = intent.getParcelableExtra(BeemIntent.EXTRA_MESSAGE);
	    onMessageReceived(context, msg);
	}
    }

    private void onMessageReceived(final Context context, Message msg) {
	NotificationManager nm = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
	CharSequence tickerText = msg.getFrom();
	Notification notification = new Notification(android.R.drawable.stat_notify_chat, tickerText, System
		.currentTimeMillis());
	notification.flags = Notification.FLAG_AUTO_CANCEL;
	notification.setLatestEventInfo(context, tickerText, context
		.getString(R.string.BeemChatManagerNewMessage), makeChatIntent(context, msg.getFrom()));
	String bareJid = StringUtils.parseBareAddress(msg.getFrom());
	sendNotification(context, bareJid.hashCode(), notification);
	Log.d("BR", "had notification : " + bareJid);
//         abortBroadcast();
    }

    /**
     * Create the PendingIntent to launch our activity if the user select this chat notification.
     * @param chat A ChatAdapter instance
     * @return A Chat activity PendingIntent
     */
    private PendingIntent makeChatIntent(final Context context, String jid) {
	Intent chatIntent = new Intent(context, com.beem.project.beem.ui.Chat.class);
	chatIntent.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT | Intent.FLAG_ACTIVITY_SINGLE_TOP
		| Intent.FLAG_ACTIVITY_NEW_TASK);
	    chatIntent.setData(new Contact(jid).toUri());
	PendingIntent contentIntent = PendingIntent.getActivity(context, 0, chatIntent,
		PendingIntent.FLAG_UPDATE_CURRENT);
	return contentIntent;
    }

    public static void sendNotification(Context context, int id, Notification notif) {
	SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences(context);
	if (settings.getBoolean(BeemApplication.NOTIFICATION_VIBRATE_KEY, true))
	    notif.defaults |= Notification.DEFAULT_VIBRATE; notif.defaults |= Notification.DEFAULT_LIGHTS;
	String ringtoneStr = settings.getString(BeemApplication.NOTIFICATION_SOUND_KEY, "");
	notif.sound = Uri.parse(ringtoneStr);
	NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
	notificationManager.notify(id, notif);
    }

}
