/**
 * 
 */
package com.beem.project.beem.ui;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.RemoteException;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

import com.beem.project.beem.BeemApplication;
import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;
import com.beem.project.beem.service.aidl.IXmppFacade;

/**
 * @author marseille
 */
public class ContactDialogAliasDialog extends Dialog {

    @SuppressWarnings("unused")
    private String      mName;
    private Contact     mContact;
    private IXmppFacade mService;

    public ContactDialogAliasDialog(Context context, Contact contact) {
	super(context);
	setContentView(R.layout.contactdialogaliasdialog);
	setTitle("Alias");
	mContact = contact;
	EditText nameText = (EditText) findViewById(R.id.CDAliasDialogName);
	nameText.setText(mContact.getName());

	Button ok = (Button) findViewById(R.id.CDAliasDialogOk);
	ok.setOnClickListener(new View.OnClickListener() {

	    @Override
	    public void onClick(View v) {
		EditText nameText = (EditText) findViewById(R.id.CDAliasDialogName);
		try {
		    mService.getRoster().setContactName(mContact.getJID(), nameText.getText().toString());
		} catch (RemoteException e) {
		    e.printStackTrace();
		}
		dismiss();
	    }

	});
    }

    public void initService() {
	Activity a = ContactDialogAliasDialog.this.getOwnerActivity();
	mService = BeemApplication.getApplication(a).getXmppFacade();
    }
}
