/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class NAPTRRecord
extends Record {
    private static final long serialVersionUID = 5191232392044947002L;
    private int order;
    private int preference;
    private byte[] flags;
    private byte[] service;
    private byte[] regexp;
    private Name replacement;

    NAPTRRecord() {
    }

    Record getObject() {
        return new NAPTRRecord();
    }

    public NAPTRRecord(Name name, int n, long l, int n2, int n3, String string, String string2, String string3, Name name2) {
        super(name, 35, n, l);
        this.order = NAPTRRecord.checkU16("order", n2);
        this.preference = NAPTRRecord.checkU16("preference", n3);
        try {
            this.flags = NAPTRRecord.byteArrayFromString(string);
            this.service = NAPTRRecord.byteArrayFromString(string2);
            this.regexp = NAPTRRecord.byteArrayFromString(string3);
        }
        catch (TextParseException textParseException) {
            throw new IllegalArgumentException(textParseException.getMessage());
        }
        this.replacement = NAPTRRecord.checkName("replacement", name2);
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.order = dNSInput.readU16();
        this.preference = dNSInput.readU16();
        this.flags = dNSInput.readCountedString();
        this.service = dNSInput.readCountedString();
        this.regexp = dNSInput.readCountedString();
        this.replacement = new Name(dNSInput);
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        this.order = tokenizer.getUInt16();
        this.preference = tokenizer.getUInt16();
        try {
            this.flags = NAPTRRecord.byteArrayFromString(tokenizer.getString());
            this.service = NAPTRRecord.byteArrayFromString(tokenizer.getString());
            this.regexp = NAPTRRecord.byteArrayFromString(tokenizer.getString());
        }
        catch (TextParseException textParseException) {
            throw tokenizer.exception(textParseException.getMessage());
        }
        this.replacement = tokenizer.getName(name);
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.order);
        stringBuffer.append(" ");
        stringBuffer.append(this.preference);
        stringBuffer.append(" ");
        stringBuffer.append(NAPTRRecord.byteArrayToString(this.flags, true));
        stringBuffer.append(" ");
        stringBuffer.append(NAPTRRecord.byteArrayToString(this.service, true));
        stringBuffer.append(" ");
        stringBuffer.append(NAPTRRecord.byteArrayToString(this.regexp, true));
        stringBuffer.append(" ");
        stringBuffer.append(this.replacement);
        return stringBuffer.toString();
    }

    public int getOrder() {
        return this.order;
    }

    public int getPreference() {
        return this.preference;
    }

    public String getFlags() {
        return NAPTRRecord.byteArrayToString(this.flags, false);
    }

    public String getService() {
        return NAPTRRecord.byteArrayToString(this.service, false);
    }

    public String getRegexp() {
        return NAPTRRecord.byteArrayToString(this.regexp, false);
    }

    public Name getReplacement() {
        return this.replacement;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU16(this.order);
        dNSOutput.writeU16(this.preference);
        dNSOutput.writeCountedString(this.flags);
        dNSOutput.writeCountedString(this.service);
        dNSOutput.writeCountedString(this.regexp);
        this.replacement.toWire(dNSOutput, null, bl);
    }

    public Name getAdditionalName() {
        return this.replacement;
    }
}

