/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.OfflineMessageHeader;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.packet.OfflineMessageInfo;
import org.jivesoftware.smackx.packet.OfflineMessageRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfflineMessageManager {
    private static final String namespace = "http://jabber.org/protocol/offline";
    private XMPPConnection connection;
    private PacketFilter packetFilter;

    public OfflineMessageManager(XMPPConnection connection) {
        this.connection = connection;
        this.packetFilter = new AndFilter(new PacketExtensionFilter("offline", namespace), new PacketTypeFilter(Message.class));
    }

    public boolean supportsFlexibleRetrieval() throws XMPPException {
        DiscoverInfo info = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(null);
        return info.containsFeature(namespace);
    }

    public int getMessageCount() throws XMPPException {
        DiscoverInfo info = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(null, namespace);
        Form extendedInfo = Form.getFormFrom(info);
        if (extendedInfo != null) {
            String value = extendedInfo.getField("number_of_messages").getValues().next();
            return Integer.parseInt(value);
        }
        return 0;
    }

    public Iterator<OfflineMessageHeader> getHeaders() throws XMPPException {
        ArrayList<OfflineMessageHeader> answer = new ArrayList<OfflineMessageHeader>();
        DiscoverItems items = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverItems(null, namespace);
        Iterator<DiscoverItems.Item> it = items.getItems();
        while (it.hasNext()) {
            DiscoverItems.Item item = it.next();
            answer.add(new OfflineMessageHeader(item));
        }
        return answer.iterator();
    }

    public Iterator<Message> getMessages(final List<String> nodes) throws XMPPException {
        ArrayList<Message> messages = new ArrayList<Message>();
        OfflineMessageRequest request = new OfflineMessageRequest();
        for (String node : nodes) {
            OfflineMessageRequest.Item item = new OfflineMessageRequest.Item(node);
            item.setAction("view");
            request.addItem(item);
        }
        PacketIDFilter responseFilter = new PacketIDFilter(request.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        AndFilter messageFilter = new AndFilter(this.packetFilter, new PacketFilter(){

            public boolean accept(Packet packet) {
                OfflineMessageInfo info = (OfflineMessageInfo)packet.getExtension("offline", OfflineMessageManager.namespace);
                return nodes.contains(info.getNode());
            }
        });
        PacketCollector messageCollector = this.connection.createPacketCollector(messageFilter);
        this.connection.sendPacket(request);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
        Message message = (Message)messageCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        while (message != null) {
            messages.add(message);
            message = (Message)messageCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        }
        messageCollector.cancel();
        return messages.iterator();
    }

    public Iterator<Message> getMessages() throws XMPPException {
        ArrayList<Message> messages = new ArrayList<Message>();
        OfflineMessageRequest request = new OfflineMessageRequest();
        request.setFetch(true);
        PacketIDFilter responseFilter = new PacketIDFilter(request.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        PacketCollector messageCollector = this.connection.createPacketCollector(this.packetFilter);
        this.connection.sendPacket(request);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
        Message message = (Message)messageCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        while (message != null) {
            messages.add(message);
            message = (Message)messageCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        }
        messageCollector.cancel();
        return messages.iterator();
    }

    public void deleteMessages(List<String> nodes) throws XMPPException {
        OfflineMessageRequest request = new OfflineMessageRequest();
        for (String node : nodes) {
            OfflineMessageRequest.Item item = new OfflineMessageRequest.Item(node);
            item.setAction("remove");
            request.addItem(item);
        }
        PacketIDFilter responseFilter = new PacketIDFilter(request.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(request);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }

    public void deleteMessages() throws XMPPException {
        OfflineMessageRequest request = new OfflineMessageRequest();
        request.setPurge(true);
        PacketIDFilter responseFilter = new PacketIDFilter(request.getPacketID());
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(request);
        IQ answer = (IQ)response.nextResult(SmackConfiguration.getPacketReplyTimeout());
        response.cancel();
        if (answer == null) {
            throw new XMPPException("No response from server.");
        }
        if (answer.getError() != null) {
            throw new XMPPException(answer.getError());
        }
    }
}

