/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.mediaimpl.jmf;

import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Manager;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.protocol.DataSource;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPControl;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionListener;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.NewParticipantEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;
import javax.media.rtp.event.SessionEvent;
import javax.media.rtp.event.StreamMappedEvent;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;

public class AudioReceiver
implements ReceiveStreamListener,
SessionListener,
ControllerListener {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(AudioReceiver.class);
    boolean dataReceived = false;
    Object dataSync;
    JingleMediaSession jingleMediaSession;

    public AudioReceiver(Object dataSync, JingleMediaSession jingleMediaSession) {
        this.dataSync = dataSync;
        this.jingleMediaSession = jingleMediaSession;
    }

    public synchronized void update(SessionEvent evt) {
        if (evt instanceof NewParticipantEvent) {
            Participant p = ((NewParticipantEvent)evt).getParticipant();
            LOGGER.error("  - A new participant had just joined: " + p.getCNAME());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(ReceiveStreamEvent evt) {
        block18: {
            Participant participant = evt.getParticipant();
            ReceiveStream stream = evt.getReceiveStream();
            if (evt instanceof RemotePayloadChangeEvent) {
                LOGGER.error("  - Received an RTP PayloadChangeEvent.");
                LOGGER.error("Sorry, cannot handle payload change.");
            } else {
                if (evt instanceof NewReceiveStreamEvent) {
                    try {
                        stream = evt.getReceiveStream();
                        DataSource ds = stream.getDataSource();
                        RTPControl ctl = (RTPControl)ds.getControl("javax.jmf.rtp.RTPControl");
                        if (ctl != null) {
                            LOGGER.error("  - Recevied new RTP stream: " + ctl.getFormat());
                        } else {
                            LOGGER.error("  - Recevied new RTP stream");
                        }
                        if (participant == null) {
                            LOGGER.error("      The sender of this stream had yet to be identified.");
                        } else {
                            LOGGER.error("      The stream comes from: " + participant.getCNAME());
                        }
                        Player p = Manager.createPlayer((DataSource)ds);
                        if (p == null) {
                            return;
                        }
                        p.addControllerListener((ControllerListener)this);
                        p.realize();
                        this.jingleMediaSession.mediaReceived(participant != null ? participant.getCNAME() : "");
                        Object object = this.dataSync;
                        synchronized (object) {
                            this.dataReceived = true;
                            this.dataSync.notifyAll();
                            break block18;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("NewReceiveStreamEvent exception " + e.getMessage());
                        return;
                    }
                }
                if (evt instanceof StreamMappedEvent) {
                    if (stream != null && stream.getDataSource() != null) {
                        DataSource ds = stream.getDataSource();
                        RTPControl ctl = (RTPControl)ds.getControl("javax.jmf.rtp.RTPControl");
                        LOGGER.error("  - The previously unidentified stream ");
                        if (ctl != null) {
                            LOGGER.error("      " + ctl.getFormat());
                        }
                        LOGGER.error("      had now been identified as sent by: " + participant.getCNAME());
                    }
                } else if (evt instanceof ByeEvent) {
                    LOGGER.error("  - Got \"bye\" from: " + participant.getCNAME());
                }
            }
        }
    }

    public synchronized void controllerUpdate(ControllerEvent ce) {
        Player p = (Player)ce.getSourceController();
        if (p == null) {
            return;
        }
        if (ce instanceof RealizeCompleteEvent) {
            p.start();
        }
        if (ce instanceof ControllerErrorEvent) {
            p.removeControllerListener((ControllerListener)this);
            LOGGER.error("Receiver internal error: " + ce);
        }
    }
}

