/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class ISDNRecord
extends Record {
    private static final long serialVersionUID = -8730801385178968798L;
    private byte[] address;
    private byte[] subAddress;

    ISDNRecord() {
    }

    Record getObject() {
        return new ISDNRecord();
    }

    public ISDNRecord(Name name, int n, long l, String string, String string2) {
        super(name, 20, n, l);
        try {
            this.address = ISDNRecord.byteArrayFromString(string);
            if (string2 != null) {
                this.subAddress = ISDNRecord.byteArrayFromString(string2);
            }
        }
        catch (TextParseException textParseException) {
            throw new IllegalArgumentException(textParseException.getMessage());
        }
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.address = dNSInput.readCountedString();
        if (dNSInput.remaining() > 0) {
            this.subAddress = dNSInput.readCountedString();
        }
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        try {
            this.address = ISDNRecord.byteArrayFromString(tokenizer.getString());
            Tokenizer.Token token = tokenizer.get();
            if (token.isString()) {
                this.subAddress = ISDNRecord.byteArrayFromString(token.value);
            } else {
                tokenizer.unget();
            }
        }
        catch (TextParseException textParseException) {
            throw tokenizer.exception(textParseException.getMessage());
        }
    }

    public String getAddress() {
        return ISDNRecord.byteArrayToString(this.address, false);
    }

    public String getSubAddress() {
        if (this.subAddress == null) {
            return null;
        }
        return ISDNRecord.byteArrayToString(this.subAddress, false);
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeCountedString(this.address);
        if (this.subAddress != null) {
            dNSOutput.writeCountedString(this.subAddress);
        }
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ISDNRecord.byteArrayToString(this.address, true));
        if (this.subAddress != null) {
            stringBuffer.append(" ");
            stringBuffer.append(ISDNRecord.byteArrayToString(this.subAddress, true));
        }
        return stringBuffer.toString();
    }
}

