/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.xmlpull.v1.XmlPullParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STUN
extends IQ {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(STUN.class);
    private List<StunServerAddress> servers = new ArrayList<StunServerAddress>();
    private String publicIp = null;
    public static final String DOMAIN = "stun";
    public static final String ELEMENT_NAME = "query";
    public static final String NAMESPACE = "google:jingleinfo";

    public List<StunServerAddress> getServers() {
        return this.servers;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    private void setPublicIp(String string) {
        this.publicIp = string;
    }

    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query xmlns='google:jingleinfo'/>");
        return stringBuilder.toString();
    }

    public static STUN getSTUNServer(XMPPConnection xMPPConnection) {
        if (!xMPPConnection.isConnected()) {
            return null;
        }
        STUN sTUN = new STUN();
        sTUN.setTo("stun." + xMPPConnection.getServiceName());
        PacketCollector packetCollector = xMPPConnection.createPacketCollector(new PacketIDFilter(sTUN.getPacketID()));
        xMPPConnection.sendPacket(sTUN);
        STUN sTUN2 = (STUN)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        return sTUN2;
    }

    public static boolean serviceAvailable(XMPPConnection xMPPConnection) {
        if (!xMPPConnection.isConnected()) {
            return false;
        }
        LOGGER.debug("Service listing");
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        try {
            DiscoverItems discoverItems = serviceDiscoveryManager.discoverItems(xMPPConnection.getServiceName());
            Iterator<DiscoverItems.Item> iterator = discoverItems.getItems();
            while (iterator.hasNext()) {
                DiscoverItems.Item item = iterator.next();
                DiscoverInfo discoverInfo = serviceDiscoveryManager.discoverInfo(item.getEntityID());
                Iterator<DiscoverInfo.Identity> iterator2 = discoverInfo.getIdentities();
                while (iterator2.hasNext()) {
                    DiscoverInfo.Identity identity = iterator2.next();
                    if (!identity.getCategory().equals("proxy") || !identity.getType().equals(DOMAIN) || !discoverInfo.containsFeature(NAMESPACE)) continue;
                    return true;
                }
                LOGGER.debug(item.getName() + "-" + discoverInfo.getType());
            }
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
        }
        return false;
    }

    static {
        ProviderManager.getInstance().addIQProvider(ELEMENT_NAME, NAMESPACE, new Provider());
    }

    public static class StunServerAddress {
        private String server;
        private String port;

        public StunServerAddress(String string, String string2) {
            this.server = string;
            this.port = string2;
        }

        public String getServer() {
            return this.server;
        }

        public String getPort() {
            return this.port;
        }
    }

    public static class Provider
    implements IQProvider {
        public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
            boolean bl = false;
            if (!xmlPullParser.getNamespace().equals(STUN.NAMESPACE)) {
                throw new Exception("Not a STUN packet");
            }
            STUN sTUN = new STUN();
            while (!bl) {
                int n = xmlPullParser.next();
                String string = xmlPullParser.getName();
                String string2 = xmlPullParser.getNamespace();
                if (n == 2) {
                    String string3;
                    if (string.equals("server")) {
                        string3 = null;
                        String string4 = null;
                        for (int i = 0; i < xmlPullParser.getAttributeCount(); ++i) {
                            if (xmlPullParser.getAttributeName(i).equals("host")) {
                                string3 = xmlPullParser.getAttributeValue(i);
                                continue;
                            }
                            if (!xmlPullParser.getAttributeName(i).equals("udp")) continue;
                            string4 = xmlPullParser.getAttributeValue(i);
                        }
                        if (string3 == null || string4 == null) continue;
                        sTUN.servers.add(new StunServerAddress(string3, string4));
                        continue;
                    }
                    if (!string.equals("publicip")) continue;
                    string3 = null;
                    for (int i = 0; i < xmlPullParser.getAttributeCount(); ++i) {
                        if (!xmlPullParser.getAttributeName(i).equals("ip")) continue;
                        string3 = xmlPullParser.getAttributeValue(i);
                    }
                    if (string3 == null || string3.equals("")) continue;
                    sTUN.setPublicIp(string3);
                    continue;
                }
                if (n != 3 || !xmlPullParser.getName().equals(STUN.ELEMENT_NAME)) continue;
                bl = true;
            }
            return sTUN;
        }
    }
}

