package com.beem.project.beem.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Intent;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import com.beem.project.beem.R;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;

/**
 * This class is the main Activity for the Beem project.
 * @author Da Risk <darisk972@gmai.com>
 */
public class Login2 extends Activity {

    private static final String TAG = "Login2";
    private SharedPreferences mSettings;
    private boolean mIsConfigured;

    /**
     * Constructor.
     */
    public Login2() {
    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.login);
	mSettings = PreferenceManager.getDefaultSharedPreferences(this);
    }

    @Override
    protected void onStart() {
	super.onStart();
	mIsConfigured = mSettings.getBoolean("PreferenceIsConfigured", false);
	//TODO utiliser une options des preference plutot.
	if (mIsConfigured) {
	    Intent i = new Intent (this, LoginAnim.class);
	    startActivityForResult(i, 42);
	}
    }

    @Override
    protected void  onActivityResult  (int requestCode, int resultCode, Intent data) {
	if (requestCode == 42) {
	    if (resultCode == Activity.RESULT_OK) {
		Log.d(TAG, "Connected !!! Launch contact list");
		Intent i = new Intent(this, ContactList.class);
		startActivity(i);
		finish();
	    } else if (resultCode == Activity.RESULT_CANCELED) { // or error ? 
		// Set an intent with data in like the error msg
		Log.d(TAG, "NOT Connected !!!");
		
	    }
	}
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
	super.onCreateOptionsMenu(menu);
	MenuInflater inflater = getMenuInflater();
	inflater.inflate(R.menu.login, menu);
	return true;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public final boolean onOptionsItemSelected(MenuItem item) {
	switch (item.getItemId()) {
	    case R.id.login_menu_settings:
		startActivity(new Intent(Login2.this, Settings.class));
		return true;
	    case R.id.login_menu_about:
		createAboutDialog();
		return true;
	    default:
		return false;
	}
    }

    /**
     * Create an about "BEEM" dialog.
     */
    private void createAboutDialog() {
	AlertDialog.Builder builder = new AlertDialog.Builder(this);
	builder.setTitle(R.string.login_about_title).setMessage(R.string.login_about_msg).setCancelable(false);
	builder.setNeutralButton(R.string.login_about_button, new DialogInterface.OnClickListener() {

	    public void onClick(DialogInterface dialog, int whichButton) {
		dialog.cancel();
	    }
	});
	AlertDialog aboutDialog = builder.create();
	aboutDialog.show();
    }

}
