package com.beem.project.beem.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import android.app.ExpandableListActivity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.ImageView;
import android.widget.SimpleExpandableListAdapter;
import android.widget.TextView;
import com.beem.project.beem.BeemApplication;
import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;
import com.beem.project.beem.service.aidl.IXMPPFacade;

public class ContactList extends ExpandableListActivity {

    private static final String TAG = "CONTACTLIST_ACT";
    private IXMPPFacade mService = null;
    private Handler mHandler;
    private BeemApplication mBeemApplication;

    @Override
    public boolean onChildClick(ExpandableListView parent, View v, int groupPosition, int childPosition, long id) {
	startActivity(new Intent(this, SendIM.class));
	return true;

    };

    @Override
    public void onCreate(Bundle saveBundle) {
	super.onCreate(saveBundle);
	mHandler = new Handler();
	mBeemApplication = BeemApplication.getApplication(this);

    }

    @Override
    public void onStart() {
	super.onStart();
	mBeemApplication.startBeemService();
	mBeemApplication.callWhenServiceConnected(mHandler, new Runnable() {
	    @Override
	    public void run() {
		mService = mBeemApplication.getXmppFacade();
		try {
		    showContactList(mService.getRoster().getContactList(), mService.getRoster().getContactList());
		} catch (RemoteException e) {
		    // TODO Auto-generated catch block
		    e.printStackTrace();
		}

	    }
	});
    }

    private void showContactList(List<Contact> listGroup, List<Contact> listContact) {
	ExpandableListAdapter Adapter;
	List<Map<String, String>> groupData = new ArrayList<Map<String, String>>();
	List<List<Map<String, String>>> childData = new ArrayList<List<Map<String, String>>>();

	if (listGroup.size() == 0)
	    listGroup.add(new Contact());
	for (int i = 0; i < listGroup.size(); i++) {
	    Map<String, String> curGroupMap = new HashMap<String, String>();

	    groupData.add(curGroupMap);
	    curGroupMap.put("NAME", "Default");

	    List<Map<String, String>> children = new ArrayList<Map<String, String>>();
	    for (int j = 0; j < listContact.size(); ++j) {
		Map<String, String> curChildMap = new HashMap<String, String>();
		children.add(curChildMap);
		curChildMap.put("NAME_CHILD", listContact.get(j).getJID());
		curChildMap.put("MSG", "Taper votre message perso");
	    }
	    childData.add(children);
	}

	Adapter = new ContactExpandableListAdapter(this, groupData, R.layout.contactlistgroup, new String[] { "NAME" },
	    new int[] { R.id.textgroup }, childData, R.layout.contactlistcontact, new String[] { "NAME_CHILD", "MSG" },
	    new int[] { R.id.textchild1, R.id.textchild2, R.id.avatar });
	setListAdapter(Adapter);
    }

    /**
     * A simple adapter which allows you to bind data to specific Views defined within the layout of an Expandable Lists
     * children (Implement getGroupView() to define the layout of parents)
     */
    public class ContactExpandableListAdapter extends SimpleExpandableListAdapter {

	private List<? extends List<? extends Map<String, ?>>> mChildData;
	private String[] mChildFrom;
	private int[] mChildTo;

	public ContactExpandableListAdapter(Context context, List<? extends Map<String, ?>> groupData, int groupLayout,
	    String[] groupFrom, int[] groupTo, List<? extends List<? extends Map<String, ?>>> childData,
	    int childLayout, String[] childFrom, int[] childTo) {
	    super(context, groupData, groupLayout, groupFrom, groupTo, childData, childLayout, childFrom, childTo);

	    mChildData = childData;
	    mChildFrom = childFrom;
	    mChildTo = childTo;

	}

	@Override
	public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView,
	    ViewGroup parent) {

	    View v;
	    if (convertView == null) {
		v = newChildView(isLastChild, parent);
	    } else {
		v = convertView;
	    }
	    bindView(v, mChildData.get(groupPosition).get(childPosition), mChildFrom, mChildTo, groupPosition,
		childPosition);
	    return v;
	}

	// This method binds my data to the Views specified in the child
	// xmllayout
	private void bindView(View view, Map<String, ?> data, String[] from, int[] to, int groupPosition,
	    int childPosition) {
	    // Apply TextViews
	    TextView v1 = (TextView) view.findViewById(to[0]);
	    if (v1 != null) {
		Log.i("CONTACT LIST 1", (String) data.get(from[0]) + " " + to[0]);
		v1.setText((String) data.get(from[0]));
	    }
	    TextView v2 = (TextView) view.findViewById(to[1]);
	    if (v2 != null) {
		Log.i("CONTACT LIST 2", (String) data.get(from[1]) + " " + to[1]);
		v2.setText((String) data.get(from[1]));
	    }
	    // Apply ImageView
	    ImageView imgV = (ImageView) view.findViewById(to[2]);
	    if (imgV != null) {
		Drawable avatar = (Drawable) getResources().getDrawable(R.drawable.avatar);
		imgV.setImageDrawable(avatar);
	    }
	}
    }

}
