/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Date;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.FormattedTime;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.TTL;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.base64;

abstract class SIGBase
extends Record {
    private static final long serialVersionUID = -3738444391533812369L;
    protected int covered;
    protected int alg;
    protected int labels;
    protected long origttl;
    protected Date expire;
    protected Date timeSigned;
    protected int footprint;
    protected Name signer;
    protected byte[] signature;

    protected SIGBase() {
    }

    public SIGBase(Name name, int n, int n2, long l, int n3, int n4, long l2, Date date, Date date2, int n5, Name name2, byte[] byArray) {
        super(name, n, n2, l);
        Type.check(n3);
        TTL.check(l2);
        this.covered = n3;
        this.alg = SIGBase.checkU8("alg", n4);
        this.labels = name.labels() - 1;
        if (name.isWild()) {
            --this.labels;
        }
        this.origttl = l2;
        this.expire = date;
        this.timeSigned = date2;
        this.footprint = SIGBase.checkU16("footprint", n5);
        this.signer = SIGBase.checkName("signer", name2);
        this.signature = byArray;
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.covered = dNSInput.readU16();
        this.alg = dNSInput.readU8();
        this.labels = dNSInput.readU8();
        this.origttl = dNSInput.readU32();
        this.expire = new Date(1000L * dNSInput.readU32());
        this.timeSigned = new Date(1000L * dNSInput.readU32());
        this.footprint = dNSInput.readU16();
        this.signer = new Name(dNSInput);
        this.signature = dNSInput.readByteArray();
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        String string = tokenizer.getString();
        this.covered = Type.value(string);
        if (this.covered < 0) {
            throw tokenizer.exception("Invalid type: " + string);
        }
        String string2 = tokenizer.getString();
        this.alg = DNSSEC.Algorithm.value(string2);
        if (this.alg < 0) {
            throw tokenizer.exception("Invalid algorithm: " + string2);
        }
        this.labels = tokenizer.getUInt8();
        this.origttl = tokenizer.getTTL();
        this.expire = FormattedTime.parse(tokenizer.getString());
        this.timeSigned = FormattedTime.parse(tokenizer.getString());
        this.footprint = tokenizer.getUInt16();
        this.signer = tokenizer.getName(name);
        this.signature = tokenizer.getBase64();
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Type.string(this.covered));
        stringBuffer.append(" ");
        stringBuffer.append(this.alg);
        stringBuffer.append(" ");
        stringBuffer.append(this.labels);
        stringBuffer.append(" ");
        stringBuffer.append(this.origttl);
        stringBuffer.append(" ");
        if (Options.check("multiline")) {
            stringBuffer.append("(\n\t");
        }
        stringBuffer.append(FormattedTime.format(this.expire));
        stringBuffer.append(" ");
        stringBuffer.append(FormattedTime.format(this.timeSigned));
        stringBuffer.append(" ");
        stringBuffer.append(this.footprint);
        stringBuffer.append(" ");
        stringBuffer.append(this.signer);
        if (Options.check("multiline")) {
            stringBuffer.append("\n");
            stringBuffer.append(base64.formatString(this.signature, 64, "\t", true));
        } else {
            stringBuffer.append(" ");
            stringBuffer.append(base64.toString(this.signature));
        }
        return stringBuffer.toString();
    }

    public int getTypeCovered() {
        return this.covered;
    }

    public int getAlgorithm() {
        return this.alg;
    }

    public int getLabels() {
        return this.labels;
    }

    public long getOrigTTL() {
        return this.origttl;
    }

    public Date getExpire() {
        return this.expire;
    }

    public Date getTimeSigned() {
        return this.timeSigned;
    }

    public int getFootprint() {
        return this.footprint;
    }

    public Name getSigner() {
        return this.signer;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU16(this.covered);
        dNSOutput.writeU8(this.alg);
        dNSOutput.writeU8(this.labels);
        dNSOutput.writeU32(this.origttl);
        dNSOutput.writeU32(this.expire.getTime() / 1000L);
        dNSOutput.writeU32(this.timeSigned.getTime() / 1000L);
        dNSOutput.writeU16(this.footprint);
        this.signer.toWire(dNSOutput, null, bl);
        dNSOutput.writeByteArray(this.signature);
    }
}

