/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.xbill.DNS.Client;

final class TCPClient
extends Client {
    public TCPClient(long l) throws IOException {
        super(SocketChannel.open(), l);
    }

    void bind(SocketAddress socketAddress) throws IOException {
        SocketChannel socketChannel = (SocketChannel)this.key.channel();
        socketChannel.socket().bind(socketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(SocketAddress socketAddress) throws IOException {
        SocketChannel socketChannel = (SocketChannel)this.key.channel();
        if (socketChannel.connect(socketAddress)) {
            return;
        }
        this.key.interestOps(8);
        try {
            while (!socketChannel.finishConnect()) {
                if (this.key.isConnectable()) continue;
                TCPClient.blockUntil(this.key, this.endTime);
            }
        }
        finally {
            if (this.key.isValid()) {
                this.key.interestOps(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(byte[] byArray) throws IOException {
        SocketChannel socketChannel = (SocketChannel)this.key.channel();
        TCPClient.verboseLog("TCP write", byArray);
        byte[] byArray2 = new byte[]{(byte)(byArray.length >>> 8), (byte)(byArray.length & 0xFF)};
        ByteBuffer[] byteBufferArray = new ByteBuffer[]{ByteBuffer.wrap(byArray2), ByteBuffer.wrap(byArray)};
        int n = 0;
        this.key.interestOps(4);
        try {
            while (n < byArray.length + 2) {
                if (this.key.isWritable()) {
                    long l = socketChannel.write(byteBufferArray);
                    if (l < 0L) {
                        throw new EOFException();
                    }
                    if ((n += (int)l) >= byArray.length + 2 || System.currentTimeMillis() <= this.endTime) continue;
                    throw new SocketTimeoutException();
                }
                TCPClient.blockUntil(this.key, this.endTime);
            }
        }
        finally {
            if (this.key.isValid()) {
                this.key.interestOps(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _recv(int n) throws IOException {
        SocketChannel socketChannel = (SocketChannel)this.key.channel();
        int n2 = 0;
        byte[] byArray = new byte[n];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.key.interestOps(1);
        try {
            while (n2 < n) {
                if (this.key.isReadable()) {
                    long l = socketChannel.read(byteBuffer);
                    if (l < 0L) {
                        throw new EOFException();
                    }
                    if ((n2 += (int)l) >= n || System.currentTimeMillis() <= this.endTime) continue;
                    throw new SocketTimeoutException();
                }
                TCPClient.blockUntil(this.key, this.endTime);
            }
        }
        finally {
            if (this.key.isValid()) {
                this.key.interestOps(0);
            }
        }
        return byArray;
    }

    byte[] recv() throws IOException {
        byte[] byArray = this._recv(2);
        int n = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
        byte[] byArray2 = this._recv(n);
        TCPClient.verboseLog("TCP read", byArray2);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] sendrecv(SocketAddress socketAddress, SocketAddress socketAddress2, byte[] byArray, long l) throws IOException {
        TCPClient tCPClient = new TCPClient(l);
        try {
            if (socketAddress != null) {
                tCPClient.bind(socketAddress);
            }
            tCPClient.connect(socketAddress2);
            tCPClient.send(byArray);
            byte[] byArray2 = tCPClient.recv();
            return byArray2;
        }
        finally {
            tCPClient.cleanup();
        }
    }

    static byte[] sendrecv(SocketAddress socketAddress, byte[] byArray, long l) throws IOException {
        return TCPClient.sendrecv(null, socketAddress, byArray, l);
    }
}

