/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.media;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.jingle.ContentNegotiator;
import org.jivesoftware.smackx.jingle.JingleActionEnum;
import org.jivesoftware.smackx.jingle.JingleException;
import org.jivesoftware.smackx.jingle.JingleNegotiator;
import org.jivesoftware.smackx.jingle.JingleNegotiatorState;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.listeners.JingleListener;
import org.jivesoftware.smackx.jingle.listeners.JingleMediaListener;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.packet.JingleContent;
import org.jivesoftware.smackx.packet.JingleDescription;
import org.jivesoftware.smackx.packet.JingleError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaNegotiator
extends JingleNegotiator {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(MediaNegotiator.class);
    private final JingleMediaManager mediaManager;
    private final List<PayloadType> localAudioPts = new ArrayList<PayloadType>();
    private final List<PayloadType> remoteAudioPts = new ArrayList<PayloadType>();
    private PayloadType bestCommonAudioPt;
    private ContentNegotiator parentNegotiator;

    public MediaNegotiator(JingleSession jingleSession, JingleMediaManager jingleMediaManager, List<PayloadType> list, ContentNegotiator contentNegotiator) {
        super(jingleSession);
        this.mediaManager = jingleMediaManager;
        this.parentNegotiator = contentNegotiator;
        this.bestCommonAudioPt = null;
        if (list != null && list.size() > 0) {
            this.localAudioPts.addAll(list);
        }
    }

    public JingleMediaManager getMediaManager() {
        return this.mediaManager;
    }

    @Override
    public List<IQ> dispatchIncomingPacket(IQ iQ, String string) throws XMPPException {
        ArrayList<IQ> arrayList = new ArrayList<IQ>();
        Packet packet = null;
        if (iQ.getType().equals(IQ.Type.ERROR)) {
            this.setNegotiatorState(JingleNegotiatorState.FAILED);
            this.triggerMediaClosed(this.getBestCommonAudioPt());
            throw new JingleException(iQ.getError().getMessage());
        }
        if (iQ.getType().equals(IQ.Type.RESULT)) {
            if (this.isExpectedId(iQ.getPacketID())) {
                this.receiveResult(iQ);
                this.removeExpectedId(iQ.getPacketID());
            }
        } else if (iQ instanceof Jingle) {
            Jingle jingle = (Jingle)iQ;
            JingleActionEnum jingleActionEnum = jingle.getAction();
            for (JingleContent jingleContent : jingle.getContentsList()) {
                JingleDescription jingleDescription;
                if (!jingleContent.getName().equals(this.parentNegotiator.getName()) || (jingleDescription = jingleContent.getDescription()) == null) continue;
                switch (jingleActionEnum) {
                    case CONTENT_ACCEPT: {
                        packet = this.receiveContentAcceptAction(jingle, jingleDescription);
                        break;
                    }
                    case CONTENT_MODIFY: {
                        break;
                    }
                    case CONTENT_REMOVE: {
                        break;
                    }
                    case SESSION_INFO: {
                        packet = this.receiveSessionInfoAction(jingle, jingleDescription);
                        break;
                    }
                    case SESSION_INITIATE: {
                        packet = this.receiveSessionInitiateAction(jingle, jingleDescription);
                        break;
                    }
                    case SESSION_ACCEPT: {
                        packet = this.receiveSessionAcceptAction(jingle, jingleDescription);
                        break;
                    }
                }
            }
        }
        if (packet != null) {
            this.addExpectedId(packet.getPacketID());
            arrayList.add((IQ)packet);
        }
        return arrayList;
    }

    private Jingle receiveResult(IQ iQ) throws XMPPException {
        Jingle jingle = null;
        return jingle;
    }

    private IQ receiveContentAcceptAction(Jingle jingle, JingleDescription jingleDescription) throws XMPPException {
        IQ iQ = null;
        List<Object> list = new ArrayList();
        list = jingleDescription.getAudioPayloadTypesList();
        this.bestCommonAudioPt = this.calculateBestCommonAudioPt(list);
        if (this.bestCommonAudioPt == null) {
            this.setNegotiatorState(JingleNegotiatorState.FAILED);
            iQ = this.session.createJingleError(jingle, JingleError.NEGOTIATION_ERROR);
        } else {
            this.setNegotiatorState(JingleNegotiatorState.SUCCEEDED);
            this.triggerMediaEstablished(this.getBestCommonAudioPt());
            LOGGER.error("Media choice:" + this.getBestCommonAudioPt().getName());
            iQ = this.session.createAck(jingle);
        }
        return iQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQ receiveSessionInitiateAction(Jingle jingle, JingleDescription jingleDescription) {
        IQ iQ = null;
        List<Object> list = new ArrayList();
        list = jingleDescription.getAudioPayloadTypesList();
        this.bestCommonAudioPt = this.calculateBestCommonAudioPt(list);
        List<PayloadType> list2 = this.remoteAudioPts;
        synchronized (list2) {
            this.remoteAudioPts.addAll(list);
        }
        if (this.bestCommonAudioPt != null) {
            this.setNegotiatorState(JingleNegotiatorState.PENDING);
        } else {
            this.setNegotiatorState(JingleNegotiatorState.FAILED);
        }
        return iQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQ receiveSessionInfoAction(Jingle jingle, JingleDescription jingleDescription) throws JingleException {
        IQ iQ = null;
        PayloadType payloadType = this.bestCommonAudioPt;
        boolean bl = false;
        List<PayloadType> list = jingleDescription.getAudioPayloadTypesList();
        if (!list.isEmpty()) {
            List<PayloadType> list2 = this.remoteAudioPts;
            synchronized (list2) {
                this.remoteAudioPts.clear();
                this.remoteAudioPts.addAll(list);
            }
            this.bestCommonAudioPt = this.calculateBestCommonAudioPt(this.remoteAudioPts);
            if (this.bestCommonAudioPt != null) {
                boolean bl2 = bl = !this.bestCommonAudioPt.equals(payloadType);
                if (payloadType != null && bl) {
                    // empty if block
                }
            } else {
                throw new JingleException(JingleError.NO_COMMON_PAYLOAD);
            }
        }
        return iQ;
    }

    private IQ receiveSessionAcceptAction(Jingle jingle, JingleDescription jingleDescription) throws JingleException {
        IQ iQ = null;
        List<Object> list = new ArrayList();
        if (this.bestCommonAudioPt == null) {
            this.bestCommonAudioPt = this.calculateBestCommonAudioPt(this.remoteAudioPts);
        }
        if (!(list = jingleDescription.getAudioPayloadTypesList()).isEmpty()) {
            if (list.size() == 1) {
                PayloadType.Audio audio = (PayloadType.Audio)list.get(0);
                if (this.bestCommonAudioPt != null && !audio.equals(this.bestCommonAudioPt)) {
                    throw new JingleException(JingleError.NEGOTIATION_ERROR);
                }
            } else if (list.size() > 1) {
                throw new JingleException(JingleError.MALFORMED_STANZA);
            }
        }
        return iQ;
    }

    public boolean isEstablished() {
        return this.getBestCommonAudioPt() != null;
    }

    public boolean isFullyEstablished() {
        return this.isEstablished() && (this.getNegotiatorState() == JingleNegotiatorState.SUCCEEDED || this.getNegotiatorState() == JingleNegotiatorState.FAILED);
    }

    private PayloadType calculateBestCommonAudioPt(List list) {
        ArrayList<PayloadType> arrayList = new ArrayList<PayloadType>();
        ArrayList arrayList2 = new ArrayList();
        PayloadType.Audio audio = null;
        if (!list.isEmpty()) {
            arrayList.addAll(this.localAudioPts);
            arrayList.retainAll(list);
            arrayList2.addAll(list);
            arrayList2.retainAll(this.localAudioPts);
            if (!arrayList.isEmpty() && !arrayList2.isEmpty()) {
                if (this.session.getInitiator().equals(this.session.getConnection().getUser())) {
                    PayloadType.Audio audio2 = null;
                    PayloadType payloadType = this.mediaManager.getPreferredPayloadType();
                    if (payloadType != null && payloadType instanceof PayloadType.Audio && arrayList.contains(payloadType)) {
                        audio2 = (PayloadType.Audio)payloadType;
                    }
                    if (audio2 == null) {
                        for (PayloadType payloadType2 : arrayList) {
                            if (!(payloadType2 instanceof PayloadType.Audio)) continue;
                            audio2 = (PayloadType.Audio)payloadType2;
                            break;
                        }
                    }
                    audio = audio2;
                } else {
                    PayloadType.Audio audio3 = null;
                    for (PayloadType payloadType : arrayList2) {
                        if (!(payloadType instanceof PayloadType.Audio)) continue;
                        audio3 = (PayloadType.Audio)payloadType;
                        break;
                    }
                    audio = audio3;
                }
            }
        }
        return audio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteAudioPayloadType(PayloadType.Audio audio) {
        if (audio != null) {
            List<PayloadType> list = this.remoteAudioPts;
            synchronized (list) {
                this.remoteAudioPts.add(audio);
            }
        }
    }

    private Jingle createAudioPayloadTypesOffer() {
        JingleContent jingleContent = new JingleContent(this.parentNegotiator.getCreator(), this.parentNegotiator.getName());
        JingleDescription.Audio audio = new JingleDescription.Audio();
        audio.addAudioPayloadTypes(this.localAudioPts);
        jingleContent.setDescription(audio);
        Jingle jingle = new Jingle(JingleActionEnum.CONTENT_ACCEPT);
        jingle.addContent(jingleContent);
        return jingle;
    }

    public PayloadType getBestCommonAudioPt() {
        return this.bestCommonAudioPt;
    }

    protected void triggerMediaEstablished(PayloadType payloadType) {
        List<JingleListener> list = this.getListenersList();
        for (JingleListener jingleListener : list) {
            if (!(jingleListener instanceof JingleMediaListener)) continue;
            JingleMediaListener jingleMediaListener = (JingleMediaListener)jingleListener;
            jingleMediaListener.mediaEstablished(payloadType);
        }
    }

    protected void triggerMediaClosed(PayloadType payloadType) {
        List<JingleListener> list = this.getListenersList();
        for (JingleListener jingleListener : list) {
            if (!(jingleListener instanceof JingleMediaListener)) continue;
            JingleMediaListener jingleMediaListener = (JingleMediaListener)jingleListener;
            jingleMediaListener.mediaClosed(payloadType);
        }
    }

    @Override
    protected void doStart() {
    }

    @Override
    public void close() {
        super.close();
        this.triggerMediaClosed(this.getBestCommonAudioPt());
    }

    public JingleDescription getJingleDescription() {
        JingleDescription.Audio audio = null;
        PayloadType payloadType = this.getBestCommonAudioPt();
        if (payloadType != null) {
            audio = new JingleDescription.Audio(payloadType);
        } else {
            audio = new JingleDescription.Audio();
            audio.addAudioPayloadTypes(this.localAudioPts);
        }
        return audio;
    }
}

