package com.beem.project.beem.ui;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;

import com.beem.project.beem.R;

public class ChangeStatus extends Activity {
    
    private TextView mTextStatus;
    private Button mOk;
    private Button mClear;
    private Spinner mSpin;
    private ArrayAdapter<String> mAdapter;
    private static final String[] mStatus = {"Available for chat", "Available", "Busy", "Away",
	"Unavailable", "Disconnected"};
    
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        // TODO Auto-generated method stub
        super.onCreate(savedInstanceState);
        setContentView(R.layout.changestatus);
        
        mTextStatus = (TextView) findViewById(R.id.ChangeStatusText);
        mOk = (Button) findViewById(R.id.ChangeStatusOk);
        mClear = (Button) findViewById(R.id.ChangeStatusClear);
        mOk.setOnClickListener(mOnClickOk);
        mClear.setOnClickListener(mOnClickClear);
        
        
        mSpin = (Spinner) findViewById(R.id.ChangeStatusSpinner);
        mAdapter = new ArrayAdapter<String>(this,
                android.R.layout.simple_spinner_item, mStatus);
        mAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        mSpin.setAdapter(mAdapter);
    }
    
    private OnClickListener mOnClickOk = new OnClickListener() {
	public void onClick(View v) {
	    CharSequence text = mTextStatus.getText();
	    String status = mAdapter.getItem(0);
	    Log.i("Selected item --->", status);
	}
    };
    
    private OnClickListener mOnClickClear = new OnClickListener() {
	public void onClick(View v) {
	    mTextStatus.setText(null);
	};
    };
}
