/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.jingle.ContentNegotiator;
import org.jivesoftware.smackx.jingle.JingleActionEnum;
import org.jivesoftware.smackx.jingle.JingleException;
import org.jivesoftware.smackx.jingle.JingleNegotiator;
import org.jivesoftware.smackx.jingle.JingleNegotiatorState;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.listeners.JingleListener;
import org.jivesoftware.smackx.jingle.listeners.JingleTransportListener;
import org.jivesoftware.smackx.jingle.nat.ICECandidate;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;
import org.jivesoftware.smackx.jingle.nat.TransportResolverListener;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.packet.JingleContent;
import org.jivesoftware.smackx.packet.JingleTransport;

public abstract class TransportNegotiator
extends JingleNegotiator {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(TransportNegotiator.class);
    public static final int CANDIDATES_ACCEPT_PERIOD = 4000;
    private final TransportResolver resolver;
    private final List<TransportCandidate> offeredCandidates = new ArrayList<TransportCandidate>();
    private final List<TransportCandidate> remoteCandidates = new ArrayList<TransportCandidate>();
    private final List<TransportCandidate> validRemoteCandidates = new ArrayList<TransportCandidate>();
    private final List<TransportCandidate> acceptedRemoteCandidates = new ArrayList<TransportCandidate>();
    private TransportCandidate acceptedLocalCandidate;
    private Thread resultThread;
    private TransportResolverListener.Resolver resolverListener;
    private ContentNegotiator parentNegotiator;

    public TransportNegotiator(JingleSession jingleSession, TransportResolver transportResolver, ContentNegotiator contentNegotiator) {
        super(jingleSession);
        this.resolver = transportResolver;
        this.parentNegotiator = contentNegotiator;
        this.resultThread = null;
    }

    public abstract JingleTransport getJingleTransport(TransportCandidate var1);

    public abstract boolean acceptableTransportCandidate(TransportCandidate var1, List<TransportCandidate> var2);

    public final TransportCandidate getBestLocalCandidate() {
        return this.resolver.getPreferredCandidate();
    }

    private void setAcceptedLocalCandidate(TransportCandidate transportCandidate) throws XMPPException {
        for (int i = 0; i < this.resolver.getCandidateCount(); ++i) {
            if (!this.resolver.getCandidate(i).getIp().equals(transportCandidate.getIp()) || this.resolver.getCandidate(i).getPort() != transportCandidate.getPort()) continue;
            this.acceptedLocalCandidate = this.resolver.getCandidate(i);
            return;
        }
        LOGGER.debug("BEST: ip=" + transportCandidate.getIp() + " port=" + transportCandidate.getPort() + " has not been offered.");
    }

    public TransportCandidate getAcceptedLocalCandidate() {
        return this.acceptedLocalCandidate;
    }

    @Override
    protected void doStart() {
        try {
            this.sendTransportCandidatesOffer();
            this.setNegotiatorState(JingleNegotiatorState.PENDING);
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
        }
    }

    @Override
    public void close() {
        super.close();
    }

    public JingleTransport getJingleTransport() {
        return this.getJingleTransport(this.getBestRemoteCandidate());
    }

    public List<TransportCandidate> getOfferedCandidates() {
        return this.offeredCandidates;
    }

    public abstract TransportCandidate getBestRemoteCandidate();

    private List<TransportCandidate> getRemoteCandidates() {
        return this.remoteCandidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemoteCandidate(TransportCandidate transportCandidate) {
        if (transportCandidate != null && this.acceptableTransportCandidate(transportCandidate, this.offeredCandidates)) {
            List<TransportCandidate> list = this.remoteCandidates;
            synchronized (list) {
                this.remoteCandidates.add(transportCandidate);
            }
            this.checkRemoteCandidate(transportCandidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOfferedCandidate(TransportCandidate transportCandidate) {
        if (transportCandidate != null) {
            List<TransportCandidate> list = this.offeredCandidates;
            synchronized (list) {
                this.offeredCandidates.add(transportCandidate);
            }
        }
    }

    private void checkRemoteCandidate(final TransportCandidate transportCandidate) {
        transportCandidate.addListener(new TransportResolverListener.Checker(){

            @Override
            public void candidateChecked(TransportCandidate transportCandidate2, boolean bl) {
                if (bl && TransportNegotiator.this.getNegotiatorState() == JingleNegotiatorState.PENDING) {
                    TransportNegotiator.this.addValidRemoteCandidate(transportCandidate);
                }
            }

            @Override
            public void candidateChecking(TransportCandidate transportCandidate2) {
            }
        });
        transportCandidate.check(this.resolver.getCandidatesList());
    }

    private boolean isEstablished() {
        return this.getBestRemoteCandidate() != null && this.getAcceptedLocalCandidate() != null;
    }

    public final boolean isFullyEstablished() {
        return this.isEstablished() && (this.getNegotiatorState() == JingleNegotiatorState.SUCCEEDED || this.getNegotiatorState() == JingleNegotiatorState.FAILED);
    }

    private void delayedCheckBestCandidate(final JingleSession jingleSession, final Jingle jingle) {
        if (this.resultThread == null && !this.getRemoteCandidates().isEmpty()) {
            this.resultThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    TransportCandidate transportCandidate;
                    int n = 7000;
                    int n2 = (int)Math.ceil(n / 1000);
                    for (int i = 0; i < n2 - 1; ++i) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        TransportCandidate transportCandidate2 = TransportNegotiator.this.getBestRemoteCandidate();
                        if (transportCandidate2 == null || TransportNegotiator.this.getNegotiatorState() != JingleNegotiatorState.PENDING) continue;
                        if (!TransportNegotiator.this.acceptedRemoteCandidates.contains(transportCandidate2)) {
                            Jingle jingle2 = new Jingle(JingleActionEnum.CONTENT_ACCEPT);
                            Object object = TransportNegotiator.this.parentNegotiator.getJingleContent();
                            ((JingleContent)object).addJingleTransport(TransportNegotiator.this.getJingleTransport(transportCandidate2));
                            jingle2.addContent((JingleContent)object);
                            jingleSession.sendFormattedJingle(jingle, jingle2);
                            TransportNegotiator.this.acceptedRemoteCandidates.add(transportCandidate2);
                        }
                        if (!TransportNegotiator.this.isEstablished() || TransportNegotiator.this.getNegotiatorState() != JingleNegotiatorState.PENDING) continue;
                        TransportNegotiator.this.setNegotiatorState(JingleNegotiatorState.SUCCEEDED);
                        TransportNegotiator.this.triggerTransportEstablished(TransportNegotiator.this.getAcceptedLocalCandidate(), transportCandidate2);
                        break;
                    }
                    if ((transportCandidate = TransportNegotiator.this.getBestRemoteCandidate()) == null) {
                        boolean bl = false;
                        for (Object object : TransportNegotiator.this.remoteCandidates) {
                            Object object2;
                            if (!(object instanceof ICECandidate) || !((ICECandidate)(object2 = (ICECandidate)object)).getType().equals("relay")) continue;
                            TransportNegotiator.this.addValidRemoteCandidate((TransportCandidate)object2);
                            bl = true;
                        }
                        if (!bl) {
                            boolean bl2 = false;
                            for (Object object2 : TransportNegotiator.this.offeredCandidates) {
                                TransportCandidate transportCandidate3;
                                if (!(object2 instanceof ICECandidate) || !((ICECandidate)(transportCandidate3 = object2)).getType().equals("relay")) continue;
                                bl2 = true;
                            }
                            if (bl2) {
                                ICECandidate iCECandidate;
                                boolean bl3 = false;
                                for (TransportCandidate transportCandidate3 : TransportNegotiator.this.remoteCandidates) {
                                    if (!(transportCandidate3 instanceof ICECandidate) || !(iCECandidate = (ICECandidate)transportCandidate3).getType().equals((Object)ICECandidate.Type.srflx)) continue;
                                    TransportNegotiator.this.addValidRemoteCandidate(iCECandidate);
                                    bl3 = true;
                                }
                                if (!bl3) {
                                    for (TransportCandidate transportCandidate3 : TransportNegotiator.this.remoteCandidates) {
                                        if (!(transportCandidate3 instanceof ICECandidate)) continue;
                                        iCECandidate = (ICECandidate)transportCandidate3;
                                        TransportNegotiator.this.addValidRemoteCandidate(iCECandidate);
                                    }
                                }
                            }
                        }
                    }
                    for (int i = 0; i < 6; ++i) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        transportCandidate = TransportNegotiator.this.getBestRemoteCandidate();
                        if (transportCandidate == null || TransportNegotiator.this.getNegotiatorState() != JingleNegotiatorState.PENDING) continue;
                        if (!TransportNegotiator.this.acceptedRemoteCandidates.contains(transportCandidate)) {
                            Jingle jingle3 = new Jingle(JingleActionEnum.CONTENT_ACCEPT);
                            JingleContent jingleContent = TransportNegotiator.this.parentNegotiator.getJingleContent();
                            jingleContent.addJingleTransport(TransportNegotiator.this.getJingleTransport(transportCandidate));
                            jingle3.addContent(jingleContent);
                            jingleSession.sendFormattedJingle(jingle, jingle3);
                            TransportNegotiator.this.acceptedRemoteCandidates.add(transportCandidate);
                        }
                        if (!TransportNegotiator.this.isEstablished()) continue;
                        TransportNegotiator.this.setNegotiatorState(JingleNegotiatorState.SUCCEEDED);
                        break;
                    }
                    if (TransportNegotiator.this.getNegotiatorState() != JingleNegotiatorState.SUCCEEDED) {
                        try {
                            TransportNegotiator.this.session.terminate("Unable to negotiate session. This may be caused by firewall configuration problems.");
                        }
                        catch (XMPPException xMPPException) {
                            xMPPException.printStackTrace();
                        }
                    }
                }
            }, "Waiting for all the transport candidates checks...");
            this.resultThread.setName("Transport Resolver Result");
            this.resultThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addValidRemoteCandidate(TransportCandidate transportCandidate) {
        if (transportCandidate != null) {
            List<TransportCandidate> list = this.validRemoteCandidates;
            synchronized (list) {
                LOGGER.debug("Added valid candidate: " + transportCandidate.getIp() + ":" + transportCandidate.getPort());
                this.validRemoteCandidates.add(transportCandidate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ArrayList getValidRemoteCandidatesList() {
        List<TransportCandidate> list = this.validRemoteCandidates;
        synchronized (list) {
            return new ArrayList<TransportCandidate>(this.validRemoteCandidates);
        }
    }

    public final Iterator getValidRemoteCandidates() {
        return Collections.unmodifiableList(this.getRemoteCandidates()).iterator();
    }

    private void addRemoteCandidates(List list) {
        if (list != null && list.size() > 0) {
            for (Object e : list) {
                this.addRemoteCandidate((TransportCandidate)e);
            }
        }
    }

    private List<TransportCandidate> obtainCandidatesList(Jingle jingle) {
        ArrayList<TransportCandidate> arrayList = new ArrayList<TransportCandidate>();
        if (jingle != null) {
            for (JingleContent jingleContent : jingle.getContentsList()) {
                if (!jingleContent.getName().equals(this.parentNegotiator.getName())) continue;
                for (JingleTransport jingleTransport : jingleContent.getJingleTransportsList()) {
                    for (JingleTransport.JingleTransportCandidate jingleTransportCandidate : jingleTransport.getCandidatesList()) {
                        TransportCandidate transportCandidate = jingleTransportCandidate.getMediaTransport();
                        arrayList.add(transportCandidate);
                    }
                }
            }
        }
        return arrayList;
    }

    private boolean isOfferStarted() {
        return this.resolver.isResolving() || this.resolver.isResolved();
    }

    private synchronized void sendTransportCandidateOffer(TransportCandidate transportCandidate) {
        if (!transportCandidate.isNull()) {
            this.addOfferedCandidate(transportCandidate);
            JingleContent jingleContent = this.parentNegotiator.getJingleContent();
            jingleContent.addJingleTransport(this.getJingleTransport(transportCandidate));
            Jingle jingle = new Jingle(JingleActionEnum.TRANSPORT_INFO);
            jingle.addContent(jingleContent);
            this.session.sendFormattedJingle(jingle);
        }
    }

    private void sendTransportCandidatesOffer() throws XMPPException {
        List<TransportCandidate> list = this.resolver.getCandidatesList();
        list.removeAll(this.offeredCandidates);
        for (TransportCandidate transportCandidate : list) {
            this.sendTransportCandidateOffer(transportCandidate);
        }
        if (this.resolverListener == null) {
            this.resolverListener = new TransportResolverListener.Resolver(){

                @Override
                public void candidateAdded(TransportCandidate transportCandidate) {
                    TransportNegotiator.this.sendTransportCandidateOffer(transportCandidate);
                }

                @Override
                public void end() {
                }

                @Override
                public void init() {
                }
            };
            this.resolver.addListener(this.resolverListener);
        }
        if (!this.resolver.isResolving() && !this.resolver.isResolved()) {
            LOGGER.debug("RESOLVER CALLED");
            this.resolver.resolve(this.session);
        }
    }

    @Override
    public final List<IQ> dispatchIncomingPacket(IQ iQ, String string) throws XMPPException {
        ArrayList<IQ> arrayList = new ArrayList<IQ>();
        Packet packet = null;
        if (iQ != null) {
            if (iQ.getType().equals(IQ.Type.ERROR)) {
                this.setNegotiatorState(JingleNegotiatorState.FAILED);
                this.triggerTransportClosed(null);
                throw new JingleException(iQ.getError().getMessage());
            }
            if (iQ.getType().equals(IQ.Type.RESULT)) {
                if (this.isExpectedId(iQ.getPacketID())) {
                    packet = this.receiveResult(iQ);
                    this.removeExpectedId(iQ.getPacketID());
                }
            } else if (iQ instanceof Jingle) {
                Jingle jingle = (Jingle)iQ;
                JingleActionEnum jingleActionEnum = jingle.getAction();
                switch (jingleActionEnum) {
                    case CONTENT_ACCEPT: {
                        packet = this.receiveContentAcceptAction(jingle);
                        break;
                    }
                    case CONTENT_MODIFY: {
                        break;
                    }
                    case CONTENT_REMOVE: {
                        break;
                    }
                    case SESSION_INFO: {
                        break;
                    }
                    case SESSION_INITIATE: {
                        packet = this.receiveSessionInitiateAction(jingle);
                        break;
                    }
                    case SESSION_ACCEPT: {
                        packet = this.receiveSessionAcceptAction(jingle);
                        break;
                    }
                    case TRANSPORT_INFO: {
                        packet = this.receiveTransportInfoAction(jingle);
                        break;
                    }
                }
            }
        }
        if (packet != null) {
            this.addExpectedId(packet.getPacketID());
            arrayList.add((IQ)packet);
        }
        return arrayList;
    }

    private Jingle receiveResult(IQ iQ) throws XMPPException {
        Jingle jingle = null;
        this.sendTransportCandidatesOffer();
        this.setNegotiatorState(JingleNegotiatorState.PENDING);
        return jingle;
    }

    private IQ receiveSessionInitiateAction(Jingle jingle) throws XMPPException {
        IQ iQ = null;
        this.sendTransportCandidatesOffer();
        this.delayedCheckBestCandidate(this.session, jingle);
        this.setNegotiatorState(JingleNegotiatorState.PENDING);
        return iQ;
    }

    private IQ receiveTransportInfoAction(Jingle jingle) throws XMPPException {
        IQ iQ = null;
        this.addRemoteCandidates(this.obtainCandidatesList(jingle));
        this.delayedCheckBestCandidate(this.session, jingle);
        iQ = this.session.createAck(jingle);
        return iQ;
    }

    private IQ receiveContentAcceptAction(Jingle jingle) throws XMPPException {
        IQ iQ = null;
        List<TransportCandidate> list = this.obtainCandidatesList(jingle);
        if (!list.isEmpty()) {
            for (TransportCandidate transportCandidate : list) {
                LOGGER.debug("Remote acccepted candidate addr: " + transportCandidate.getIp());
            }
            TransportCandidate transportCandidate = list.get(0);
            this.setAcceptedLocalCandidate(transportCandidate);
            if (this.isEstablished()) {
                LOGGER.debug(transportCandidate.getIp() + " is set active");
            }
        }
        return iQ;
    }

    private IQ receiveSessionAcceptAction(Jingle jingle) {
        IQ iQ = null;
        LOGGER.debug("Transport stabilished");
        return iQ;
    }

    private void triggerTransportEstablished(TransportCandidate transportCandidate, TransportCandidate transportCandidate2) {
        List<JingleListener> list = this.getListenersList();
        for (JingleListener jingleListener : list) {
            if (!(jingleListener instanceof JingleTransportListener)) continue;
            JingleTransportListener jingleTransportListener = (JingleTransportListener)jingleListener;
            LOGGER.debug("triggerTransportEstablished " + transportCandidate.getLocalIp() + ":" + transportCandidate.getPort() + " <-> " + transportCandidate2.getIp() + ":" + transportCandidate2.getPort());
            jingleTransportListener.transportEstablished(transportCandidate, transportCandidate2);
        }
    }

    private void triggerTransportClosed(TransportCandidate transportCandidate) {
        List<JingleListener> list = this.getListenersList();
        for (JingleListener jingleListener : list) {
            if (!(jingleListener instanceof JingleTransportListener)) continue;
            JingleTransportListener jingleTransportListener = (JingleTransportListener)jingleListener;
            jingleTransportListener.transportClosed(transportCandidate);
        }
    }

    public static final class Ice
    extends TransportNegotiator {
        public Ice(JingleSession jingleSession, TransportResolver transportResolver, ContentNegotiator contentNegotiator) {
            super(jingleSession, transportResolver, contentNegotiator);
        }

        @Override
        public JingleTransport getJingleTransport(TransportCandidate transportCandidate) {
            JingleTransport.Ice ice = new JingleTransport.Ice();
            ice.addCandidate(new JingleTransport.Ice.Candidate(transportCandidate));
            return ice;
        }

        @Override
        public TransportCandidate getBestRemoteCandidate() {
            ICECandidate iCECandidate = null;
            ArrayList arrayList = this.getValidRemoteCandidatesList();
            if (!arrayList.isEmpty()) {
                int n = -1;
                ICECandidate iCECandidate2 = null;
                for (ICECandidate iCECandidate3 : arrayList) {
                    if (iCECandidate3.getPreference() <= n) continue;
                    iCECandidate2 = iCECandidate3;
                    n = iCECandidate3.getPreference();
                }
                iCECandidate = iCECandidate2;
            }
            if (iCECandidate != null && iCECandidate.getType().equals("relay")) {
                LOGGER.debug("Relay Type");
            }
            return iCECandidate;
        }

        @Override
        public boolean acceptableTransportCandidate(TransportCandidate transportCandidate, List<TransportCandidate> list) {
            return transportCandidate instanceof ICECandidate;
        }
    }

    public static final class RawUdp
    extends TransportNegotiator {
        public RawUdp(JingleSession jingleSession, TransportResolver transportResolver, ContentNegotiator contentNegotiator) {
            super(jingleSession, transportResolver, contentNegotiator);
        }

        @Override
        public JingleTransport getJingleTransport(TransportCandidate transportCandidate) {
            JingleTransport.RawUdp rawUdp = new JingleTransport.RawUdp();
            rawUdp.addCandidate(new JingleTransport.RawUdp.Candidate(transportCandidate));
            return rawUdp;
        }

        @Override
        public TransportCandidate getBestRemoteCandidate() {
            ArrayList arrayList = this.getValidRemoteCandidatesList();
            if (!arrayList.isEmpty()) {
                LOGGER.debug("RAW CAND");
                return (TransportCandidate)arrayList.get(0);
            }
            LOGGER.debug("No Remote Candidate");
            return null;
        }

        @Override
        public boolean acceptableTransportCandidate(TransportCandidate transportCandidate, List<TransportCandidate> list) {
            return transportCandidate instanceof TransportCandidate.Fixed;
        }
    }
}

