package com.beem.project.beem.ui;

import android.app.Activity;
import android.app.Dialog;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.view.View;
import android.widget.Button;

import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;
import com.beem.project.beem.service.aidl.IXmppFacade;

/**
 * This activity class provides the view to show dialog when long click on contact list.
 * @author marseille
 */
public class ContactDialog extends Dialog {

    private static final Intent SERVICE_INTENT = new Intent();
    private final Contact mContact;
    private final Context mContext;
    private IXmppFacade mXmppFacade;
    private final ServiceConnection mServConn = new BeemServiceConnection();

    static {
	SERVICE_INTENT.setComponent(new ComponentName("com.beem.project.beem", "com.beem.project.beem.BeemService"));
    }

    /**
     * Constructor.
     * @param context context where is call the dialog.
     * @param curContact current contact.
     */
    public ContactDialog(final Context context, final Contact curContact) {
	super(context);
	mContext = context;

	setContentView(R.layout.contactdialog);
	mContact = curContact;
	setTitle(curContact.getJID());

	Button button = (Button) findViewById(R.id.CDChat);
	button.setOnClickListener(new ChatListener());
	button = (Button) findViewById(R.id.CDInfos);
	button.setOnClickListener(new InfosListener());
	button = (Button) findViewById(R.id.CDCall);
	button.setOnClickListener(new CallListener());
	mContext.bindService(SERVICE_INTENT, mServConn, Service.BIND_AUTO_CREATE);
    }

    @Override
    public void dismiss() {
	super.dismiss();
	mContext.unbindService(mServConn);
    }

    /**
     * Event simple click on call button.
     */
    class CallListener implements View.OnClickListener {

	/**
	 * Constructor.
	 */
	public CallListener() {
	}

	@Override
	public void onClick(View v) {
	    try {
		// TODO permettre a l'user de choisir a quel ressource il veut
		// faire le call.
		mXmppFacade.call(mContact.getJID() + "/BEEM");
	    } catch (RemoteException e) {
		e.printStackTrace();
	    }
	}
    }

    /**
     * Event simple click on chat button.
     */
    class ChatListener implements View.OnClickListener {

	/**
	 * Constructor.
	 */
	public ChatListener() {
	}

	@Override
	public void onClick(View v) {
	    Activity a = ContactDialog.this.getOwnerActivity();
	    Intent i = new Intent(mContext, SendIM.class);
	    i.setData(mContact.toUri());
	    a.startActivity(i);
	    dismiss();
	}

    }

    /**
     * Event simple click on info button.
     */
    class InfosListener implements View.OnClickListener {

	/**
	 * Constructor.
	 */
	public InfosListener() {
	}

	@Override
	public void onClick(View v) {
	    Activity a = ContactDialog.this.getOwnerActivity();
	    Intent i = new Intent(mContext, UserInfo.class);
	    i.putExtra("contact", mContact);
	    a.startActivity(i);
	    dismiss();
	}

    }

    /**
     * The service connection used to connect to the Beem service.
     */
    private class BeemServiceConnection implements ServiceConnection {

	/**
	 * Constructor.
	 */
	public BeemServiceConnection() {
	}

	@Override
	public void onServiceConnected(ComponentName name, IBinder service) {
	    mXmppFacade = IXmppFacade.Stub.asInterface(service);
	}

	@Override
	public void onServiceDisconnected(ComponentName name) {
	    mXmppFacade = null;
	}
    }

}
