package com.beem.project.beem.jingle;

import java.net.DatagramSocket;
import java.net.SocketException;

import jlibrtp.Participant;
import jlibrtp.RTPAppIntf;
import jlibrtp.RTPSession;

/**
 * abstract RTP receiver class.
 * @author nikita
 */
public abstract class RTPReceiver implements Runnable, RTPAppIntf {

    private boolean mKillme;
    private RTPSession mRtpSession;

    /**
     * constructor.
     * @param rtpPort local or distant?.
     */
    public RTPReceiver(final int rtpPort) {
	DatagramSocket rtpSocket = null;

	try {
	    rtpSocket = new DatagramSocket(rtpPort);
	} catch (SocketException e) {
	    e.printStackTrace();
	    return;
	}
	mRtpSession = new RTPSession(rtpSocket, null);
	mRtpSession.naivePktReception(true);
	mRtpSession.RTPSessionRegister(this, null, null);
    }

    @Override
    public int frameSize(int payloadType) {
	return 1;
    }

    @Override
    public void run() {
	start();
	this.mRtpSession.endSession();
    }

    /**
     * main reception loop.
     */
    protected abstract void start();

    /**
     * Stop the reception.
     */
    public void stop() {
	this.setKillme(true);
    }

    @Override
    public void userEvent(int arg0, Participant[] arg1) {
	// TODO Auto-generated method stub
    }

    /**
     * mKillme setter.
     * @param killme the mKillme to set
     */
    public void setKillme(final boolean killme) {
	this.mKillme = killme;
    }

    /**
     * mKillme getter.
     * @return the mKillme
     */
    public boolean isKillme() {
	return mKillme;
    }
}
