package com.beem.project.beem.jingle;

import java.util.ArrayList;
import java.util.List;

import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

import android.content.Context;

/**
 * RTPMediaManager, gere les payloads et renvoie une session RTP.
 * @author nikita
 */
public class MicrophoneRTPManager extends JingleMediaManager {
	/**
	 * RTP media name.
	 */
	public static final String MEDIA_NAME = "Microphone";

	private List<PayloadType> mPayloads;

	private Context mCtx;

	/**
	 * Manage Microphone data transmission trough RTP.
	 * @param transportManager current jingle transport manager(basic,upnp,ice...).
	 */
	public MicrophoneRTPManager(final JingleTransportManager transportManager, Context ctx) {
		super(transportManager);
		setupPayloads();
		mCtx = ctx;
	}

	@Override
	public JingleMediaSession createMediaSession(PayloadType payloadType, TransportCandidate remote,
			TransportCandidate local, JingleSession jingleSession) {
		return new RTPAudioSession(payloadType, remote, local, null, jingleSession, mCtx);
	}

	@Override
	public String getName() {
		return MEDIA_NAME;
	}

	@Override
	public List<PayloadType> getPayloads() {
		return mPayloads;
	}

	/**
	 * Supported payload list.
	 */
	private void setupPayloads() {
		mPayloads = new ArrayList<PayloadType>();
		mPayloads.add(new PayloadType.Audio(8, "PCMA"));
		mPayloads.add(new PayloadType.Audio(9, "G722"));
		mPayloads.add(new PayloadType.Audio(3, "GSM"));
	}
}
