package org.sipdroid.media.codecs;

public class GSM extends Codec {

	public static final CodecInfo mCodecInfo = new CodecInfo();

	static {
		System.loadLibrary("gsm");
		mCodecInfo.displayName = "GSM";
		mCodecInfo.rtpPayloadName = "GSM";
		mCodecInfo.description = "GSM Full Rate codec";
		mCodecInfo.rtpPayloadCode = 3;
		mCodecInfo.samplingRate = 8000;
		mCodecInfo.rtpSampleDivider = 1;
		mCodecInfo.minFrameTimeMsecs = 20;
		mCodecInfo.codecFrameSize = 33;
		CodecManager.registerAudioCodec(new GSM());
	}

	public class GSMContext extends Context {
		public long ctx;
	}

	@Override
	public Context initDecoder() {
		GSMContext decoderCtx = new GSMContext();
		decoderCtx.ctx = GSMJNI.create();
		return decoderCtx;
	}

	@Override
	public Context initEncoder() {
		GSMContext encoderCtx = new GSMContext();
		encoderCtx.ctx = GSMJNI.create();
		return encoderCtx;
	}

	@Override
	public void cleanDecoder(Context ctx) {
		GSMJNI.destroy(((GSMContext)ctx).ctx);
	}

	@Override
	public void cleanEncoder(Context ctx) {
		GSMJNI.destroy(((GSMContext)ctx).ctx);
	}

	@Override
	public int decode(Context ctx, byte[] indata, int inoffset, int size,
			short[] outsample, int outoffset) {
		return GSMJNI.decode(((GSMContext)ctx).ctx, indata, inoffset, outsample, outoffset);
	}

	@Override
	public int encode(Context ctx, short[] insample, int inoffset, int size,
			byte[] outdata, int outoffset) {
		GSMJNI.encode(((GSMContext)ctx).ctx, insample, inoffset, outdata, outoffset);
		return size;
	}

	@Override
	public CodecInfo getInfo() {
		return mCodecInfo;
	}

	static public void load(){
	}
}
