package org.sipdroid.media.codecs;

public class G722 extends Codec {

	public static final CodecInfo mCodecInfo = new CodecInfo();

	static {
		System.loadLibrary("g722");
		mCodecInfo.displayName = "G722";
		mCodecInfo.rtpPayloadName = "G722";
		mCodecInfo.description = "G722 16kHz codec";
		mCodecInfo.rtpPayloadCode = 9;
		mCodecInfo.samplingRate = 16000;
		mCodecInfo.rtpSampleDivider = 2;
		mCodecInfo.minFrameTimeMsecs = 20;
		mCodecInfo.codecFrameSize = 160;
		CodecManager.registerAudioCodec(new G722());
	}

	public class G722Context extends Context {
		public long ctx;
	}

	@Override
	public Context initDecoder() {
		G722Context decoderCtx = new G722Context();
		decoderCtx.ctx = G722JNI.decodeInit(decoderCtx.ctx, mCodecInfo.codecFrameSize, 0);
		return decoderCtx;
	}

	@Override
	public Context initEncoder() {
		G722Context encoderCtx = new G722Context();
		encoderCtx.ctx = G722JNI.encodeInit(encoderCtx.ctx, mCodecInfo.codecFrameSize, 0);
		return encoderCtx;
	}

	@Override
	public void cleanDecoder(Context ctx) {
		G722JNI.decodeRelease(((G722Context)ctx).ctx);
	}

	@Override
	public void cleanEncoder(Context ctx) {
		G722JNI.encodeRelease(((G722Context)ctx).ctx);
	}

	@Override
	public int decode(Context ctx, byte[] indata, int inoffset, int size,
			short[] outsample, int outoffset) {
		return G722JNI.decode(((G722Context)ctx).ctx, indata, inoffset, outsample, outoffset, size);
	}

	@Override
	public int encode(Context ctx, short[] insample, int inoffset, int size,
			byte[] outdata, int outoffset) {
		G722JNI.encode(((G722Context)ctx).ctx, insample, inoffset, outdata, outoffset, size);
		return size;
	}

	@Override
	public CodecInfo getInfo() {
		return mCodecInfo;
	}

	static public void load(){
	}
}
