/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.jingle.media.ContentInfo;

public class JingleContentInfo
implements PacketExtension {
    protected ContentInfo mediaInfoElement;
    private String namespace;

    public JingleContentInfo() {
        this(null);
    }

    public JingleContentInfo(ContentInfo contentInfo) {
        this.mediaInfoElement = contentInfo;
    }

    public ContentInfo getMediaInfo() {
        return this.mediaInfoElement;
    }

    public String getElementName() {
        return this.getMediaInfo().toString();
    }

    protected void setNamespace(String string) {
        this.namespace = string;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.getElementName()).append(" xmlns=\"");
        stringBuilder.append(this.getNamespace()).append("\" ");
        stringBuilder.append("/>");
        return stringBuilder.toString();
    }

    public static class Audio
    extends JingleContentInfo {
        public static final String NAMESPACE = "urn:xmpp:jingle:apps:rtp:1";

        public Audio(ContentInfo contentInfo) {
            super(contentInfo);
            this.setNamespace(NAMESPACE);
        }

        public String getNamespace() {
            return NAMESPACE;
        }

        public static class Ringing
        extends Audio {
            public Ringing() {
                super(ContentInfo.Audio.RINGING);
            }
        }

        public static class Queued
        extends Audio {
            public Queued() {
                super(ContentInfo.Audio.QUEUED);
            }
        }

        public static class Mute
        extends Audio {
            public Mute() {
                super(ContentInfo.Audio.MUTE);
            }
        }

        public static class Hold
        extends Audio {
            public Hold() {
                super(ContentInfo.Audio.HOLD);
            }
        }

        public static class Busy
        extends Audio {
            public Busy() {
                super(ContentInfo.Audio.BUSY);
            }
        }
    }
}

