/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingle.JingleManager;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.packet.Jingle;

public class JingleSessionRequest {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(JingleSessionRequest.class);
    private final Jingle jingle;
    private final JingleManager manager;

    public JingleSessionRequest(JingleManager jingleManager, Jingle jingle) {
        this.manager = jingleManager;
        this.jingle = jingle;
    }

    public String getFrom() {
        return this.jingle.getFrom();
    }

    public String getSessionID() {
        return this.jingle.getSid();
    }

    public Jingle getJingle() {
        return this.jingle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JingleSession accept(JingleSession jingleSession) throws XMPPException {
        JingleManager jingleManager = this.manager;
        synchronized (jingleManager) {
            jingleSession.setSid(this.getSessionID());
            jingleSession.updatePacketListener();
            jingleSession.receivePacketAndRespond(this.getJingle());
        }
        return jingleSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reject() {
        JingleSession jingleSession = null;
        JingleManager jingleManager = this.manager;
        synchronized (jingleManager) {
            try {
                jingleSession = this.manager.createIncomingJingleSession(this);
                jingleSession.setSid(this.getSessionID());
                jingleSession.updatePacketListener();
                jingleSession.terminate("Declined");
            }
            catch (XMPPException xMPPException) {
                LOGGER.error("", xMPPException);
            }
        }
    }
}

