/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.PasswordCallback;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.UserAuthentication;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.Authentication;
import org.jivesoftware.smack.packet.IQ;

class NonSASLAuthentication
implements UserAuthentication {
    private Connection connection;

    public NonSASLAuthentication(Connection connection) {
        this.connection = connection;
    }

    @Override
    public String authenticate(String string, String string2, CallbackHandler callbackHandler) throws XMPPException {
        PasswordCallback passwordCallback = new PasswordCallback("Password: ", false);
        try {
            callbackHandler.handle(new Callback[]{passwordCallback});
            return this.authenticate(string, String.valueOf(passwordCallback.getPassword()), string2);
        }
        catch (Exception exception) {
            throw new XMPPException("Unable to determine password.", exception);
        }
    }

    @Override
    public String authenticate(String string, String string2, String string3) throws XMPPException {
        Authentication authentication = new Authentication();
        authentication.setType(IQ.Type.GET);
        authentication.setUsername(string);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(authentication.getPacketID()));
        this.connection.sendPacket(authentication);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        if (iQ == null) {
            throw new XMPPException("No response from the server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
        Authentication authentication2 = (Authentication)iQ;
        packetCollector.cancel();
        Authentication authentication3 = new Authentication();
        authentication3.setUsername(string);
        if (authentication2.getDigest() != null) {
            authentication3.setDigest(this.connection.getConnectionID(), string2);
        } else if (authentication2.getPassword() != null) {
            authentication3.setPassword(string2);
        } else {
            throw new XMPPException("Server does not support compatible authentication mechanism.");
        }
        authentication3.setResource(string3);
        packetCollector = this.connection.createPacketCollector(new PacketIDFilter(authentication3.getPacketID()));
        this.connection.sendPacket(authentication3);
        iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        if (iQ == null) {
            throw new XMPPException("Authentication failed.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
        packetCollector.cancel();
        return iQ.getTo();
    }

    @Override
    public String authenticateAnonymously() throws XMPPException {
        Authentication authentication = new Authentication();
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(authentication.getPacketID()));
        this.connection.sendPacket(authentication);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        if (iQ == null) {
            throw new XMPPException("Anonymous login failed.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
        packetCollector.cancel();
        if (iQ.getTo() != null) {
            return iQ.getTo();
        }
        return this.connection.getServiceName() + "/" + ((Authentication)iQ).getResource();
    }
}

