/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingle.JingleNegotiatorState;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.listeners.JingleListener;

public abstract class JingleNegotiator {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(JingleNegotiator.class);
    protected JingleSession session;
    private final List<JingleListener> listeners = new ArrayList<JingleListener>();
    private String expectedAckId;
    private JingleNegotiatorState state;
    private boolean isStarted;

    public JingleNegotiator() {
        this(null);
    }

    public JingleNegotiator(JingleSession jingleSession) {
        this.session = jingleSession;
        this.state = JingleNegotiatorState.PENDING;
    }

    public JingleNegotiatorState getNegotiatorState() {
        return this.state;
    }

    public void setNegotiatorState(JingleNegotiatorState jingleNegotiatorState) {
        JingleNegotiatorState jingleNegotiatorState2 = this.state;
        LOGGER.debug("Negotiator state change: " + (Object)((Object)jingleNegotiatorState2) + "->" + (Object)((Object)jingleNegotiatorState) + "(" + this.getClass().getSimpleName() + ")");
        switch (jingleNegotiatorState) {
            case PENDING: {
                break;
            }
            case FAILED: {
                break;
            }
            case SUCCEEDED: {
                break;
            }
        }
        this.state = jingleNegotiatorState;
    }

    public Connection getConnection() {
        if (this.session != null) {
            return this.session.getConnection();
        }
        return null;
    }

    public JingleSession getSession() {
        return this.session;
    }

    public void setSession(JingleSession jingleSession) {
        this.session = jingleSession;
    }

    public void addExpectedId(String string) {
        this.expectedAckId = string;
    }

    public boolean isExpectedId(String string) {
        if (string != null) {
            return string.equals(this.expectedAckId);
        }
        return false;
    }

    public void removeExpectedId(String string) {
        this.addExpectedId(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(JingleListener jingleListener) {
        List<JingleListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(jingleListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(JingleListener jingleListener) {
        List<JingleListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(jingleListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<JingleListener> getListenersList() {
        ArrayList<JingleListener> arrayList;
        List<JingleListener> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<JingleListener>(this.listeners);
        }
        return arrayList;
    }

    public abstract List<IQ> dispatchIncomingPacket(IQ var1, String var2) throws XMPPException;

    public void start() {
        this.isStarted = true;
        this.doStart();
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    protected abstract void doStart();

    public void close() {
    }
}

