/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PublishItem;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.SyncPacketSend;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafNode
extends Node {
    LeafNode(XMPPConnection connection, String nodeName) {
        super(connection, nodeName);
    }

    public DiscoverItems discoverItems() throws XMPPException {
        DiscoverItems items = new DiscoverItems();
        items.setTo(this.to);
        items.setNode(this.getId());
        return (DiscoverItems)SyncPacketSend.getReply(this.con, items);
    }

    public <T extends Item> List<T> getItems() throws XMPPException {
        PubSub request = this.createPubsubPacket(IQ.Type.GET, new NodeExtension(PubSubElementType.ITEMS, this.getId()));
        PubSub result = (PubSub)SyncPacketSend.getReply(this.con, request);
        ItemsExtension itemsElem = (ItemsExtension)result.getExtension(PubSubElementType.ITEMS);
        return itemsElem.getItems();
    }

    public <T extends Item> List<T> getItems(Collection<String> ids) throws XMPPException {
        ArrayList<Item> itemList = new ArrayList<Item>(ids.size());
        for (String id : ids) {
            itemList.add(new Item(id));
        }
        PubSub request = this.createPubsubPacket(IQ.Type.GET, new ItemsExtension(ItemsExtension.ItemsElementType.items, this.getId(), itemList, null));
        PubSub result = (PubSub)SyncPacketSend.getReply(this.con, request);
        ItemsExtension itemsElem = (ItemsExtension)result.getExtension(PubSubElementType.ITEMS);
        return itemsElem.getItems();
    }

    public <T extends Item> List<T> getItems(int maxItems) throws XMPPException {
        PubSub request = this.createPubsubPacket(IQ.Type.GET, new ItemsExtension(this.getId(), maxItems));
        PubSub result = (PubSub)SyncPacketSend.getReply(this.con, request);
        ItemsExtension itemsElem = (ItemsExtension)result.getExtension(PubSubElementType.ITEMS);
        return itemsElem.getItems();
    }

    public void publish() {
        PubSub packet = this.createPubsubPacket(IQ.Type.SET, new NodeExtension(PubSubElementType.PUBLISH, this.getId()));
        this.con.sendPacket(packet);
    }

    public <T extends Item> void publish(T item) {
        ArrayList<T> items = new ArrayList<T>(1);
        items.add(item == null ? new Item() : item);
        this.publish(items);
    }

    public <T extends Item> void publish(Collection<T> items) {
        PubSub packet = this.createPubsubPacket(IQ.Type.SET, new PublishItem<T>(this.getId(), items));
        this.con.sendPacket(packet);
    }

    public void send() throws XMPPException {
        PubSub packet = this.createPubsubPacket(IQ.Type.SET, new NodeExtension(PubSubElementType.PUBLISH, this.getId()));
        SyncPacketSend.getReply(this.con, packet);
    }

    public <T extends Item> void send(T item) throws XMPPException {
        ArrayList<T> items = new ArrayList<T>(1);
        items.add(item == null ? new Item() : item);
        this.send(items);
    }

    public <T extends Item> void send(Collection<T> items) throws XMPPException {
        PubSub packet = this.createPubsubPacket(IQ.Type.SET, new PublishItem<T>(this.getId(), items));
        SyncPacketSend.getReply(this.con, packet);
    }

    public void deleteAllItems() throws XMPPException {
        PubSub request = this.createPubsubPacket(IQ.Type.SET, new NodeExtension(PubSubElementType.PURGE_OWNER, this.getId()), PubSubElementType.PURGE_OWNER.getNamespace());
        SyncPacketSend.getReply(this.con, request);
    }

    public void deleteItem(String itemId) throws XMPPException {
        ArrayList<String> items = new ArrayList<String>(1);
        items.add(itemId);
        this.deleteItem(items);
    }

    public void deleteItem(Collection<String> itemIds) throws XMPPException {
        ArrayList<Item> items = new ArrayList<Item>(itemIds.size());
        for (String id : itemIds) {
            items.add(new Item(id));
        }
        PubSub request = this.createPubsubPacket(IQ.Type.SET, new ItemsExtension(ItemsExtension.ItemsElementType.retract, this.getId(), items, null));
        SyncPacketSend.getReply(this.con, request);
    }
}

