package com.beem.project.beem.provider;

import android.net.Uri;
import android.provider.BaseColumns;

/**
 * Convenience definitions for BEEM's providers
 */
public final class Beem {

    /**
     * Contacts table
     */
    public static final class Contacts implements BaseColumns {

	/**
	 * The query used to create the table
	 */
	public final static String QUERY_CREATE       = "CREATE TABLE " + Beem.CONTACTS_TABLE_NAME + " ("
	                                                      + BaseColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT,"
	                                                      + Contacts.UID + " INTEGER, " + Contacts.JID
	                                                      + " INTEGER," + Contacts.NICKNAME + " TEXT,"
	                                                      + Contacts.ALIAS + " TEXT," + Contacts.DATE_CREATED
	                                                      + " INTEGER," + Contacts.DATE_MODIFIED + " INTEGER"
	                                                      + ");";

	/**
	 * The content:// style URL for Contacts table
	 */
	public final static Uri    CONTENT_URI        = Uri.parse("content://" + AUTHORITY + "/contacts");

	/**
	 * The MIME type of {@link #CONTENT_URI} providing a directory of contacts.
	 */
	public static final String CONTENT_TYPE       = "vnd.android.cursor.dir/vnd.beem.project.contact";

	/**
	 * The MIME type of a {@link #CONTENT_URI} sub-directory of a single contact.
	 */
	public static final String CONTENT_ITEM_TYPE  = "vnd.android.cursor.item/vnd.beem.project.contact";

	/**
	 * The default sort order for this table
	 */
	public final static String DEFAULT_SORT_ORDER = "nickname ASC";

	/**
	 * The user id having the contact
	 * <P>
	 * Type: INTEGER
	 * </P>
	 */
	public final static String UID                = "uid";

	/**
	 * The JabberID of the contact
	 * <P>
	 * Type: INTEGER
	 * </P>
	 */
	public final static String JID                = "jid";

	/**
	 * The nickname of the contact
	 * <P>
	 * Type: TEXT
	 * </P>
	 */
	public final static String NICKNAME           = "nickname";

	/**
	 * The alias of the contact
	 * <P>
	 * Type: TEXT
	 * </P>
	 */
	public final static String ALIAS              = "alias";

	/**
	 * The timestamp for when the contact was created
	 * <P>
	 * Type: INTEGER (long from System.curentTimeMillis())
	 * </P>
	 */
	public final static String DATE_CREATED       = "created";

	/**
	 * The timestamp for when the contact was last modified
	 * <P>
	 * Type: INTEGER (long from System.curentTimeMillis())
	 * </P>
	 */
	public final static String DATE_MODIFIED      = "modified";

    }

    /**
     * Users table
     */
    public static final class Users implements BaseColumns {

	/**
	 * The query used to create the table
	 */
	public final static String QUERY_CREATE       = "CREATE TABLE " + Beem.USERS_TABLE_NAME + " ("
	                                                      + BaseColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT,"
	                                                      + Users.JUSERNAME + " TEXT," + Users.DATE_CREATED
	                                                      + " INTEGER," + Users.DATE_MODIFIED + " INTEGER" + ");";

	/**
	 * The content:// style URL for Contacts table
	 */
	public final static Uri    CONTENT_URI        = Uri.parse("content://" + AUTHORITY + "/users");

	/**
	 * The MIME type of {@link #CONTENT_URI} providing a directory of users.
	 */
	public static final String CONTENT_TYPE       = "vnd.android.cursor.dir/vnd.beem.project.user";

	/**
	 * The MIME type of a {@link #CONTENT_URI} sub-directory of a single user.
	 */
	public static final String CONTENT_ITEM_TYPE  = "vnd.android.cursor.item/vnd.beem.project.user";

	/**
	 * The default sort order for this table
	 */
	public final static String DEFAULT_SORT_ORDER = "_id ASC";

	/**
	 * The Jabber username of the user
	 * <P>
	 * Type: TEXT
	 * </P>
	 */
	public final static String JUSERNAME          = "username";

	/**
	 * The timestamp for when the user was created
	 * <P>
	 * Type: INTEGER (long from System.curentTimeMillis())
	 * </P>
	 */
	public final static String DATE_CREATED       = "created";

	/**
	 * The timestamp for when the user was last modified
	 * <P>
	 * Type: INTEGER (long from System.curentTimeMillis())
	 * </P>
	 */
	public final static String DATE_MODIFIED      = "modified";
    }

    public final static String AUTHORITY           = "com.beem.project.provider";

    public final static String DB_NAME             = "beem.db";
    public final static int    DB_VERSION          = 2;

    public final static String USERS_TABLE_NAME    = "users";

    public final static String CONTACTS_TABLE_NAME = "contacts";

    /**
     * Constructor
     */
    private Beem() {
    }
}
