/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.jingle.media.PayloadType;

public abstract class JingleContentDescription
implements PacketExtension {
    public static final String NODENAME = "description";
    private final List payloads = new ArrayList();

    @Override
    public String getElementName() {
        return NODENAME;
    }

    @Override
    public abstract String getNamespace();

    public abstract String getMediaType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJinglePayloadType(JinglePayloadType jinglePayloadType) {
        List list = this.payloads;
        synchronized (list) {
            this.payloads.add(jinglePayloadType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioPayloadTypes(List list) {
        List list2 = this.payloads;
        synchronized (list2) {
            for (PayloadType.Audio audio : list) {
                this.addJinglePayloadType(new JinglePayloadType.Audio(audio));
            }
        }
    }

    public Iterator getJinglePayloadTypes() {
        return Collections.unmodifiableList(this.getJinglePayloadTypesList()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getJinglePayloadTypesList() {
        List list = this.payloads;
        synchronized (list) {
            return new ArrayList(this.payloads);
        }
    }

    public ArrayList getAudioPayloadTypesList() {
        ArrayList<PayloadType> arrayList = new ArrayList<PayloadType>();
        Iterator iterator = this.getJinglePayloadTypes();
        while (iterator.hasNext()) {
            JinglePayloadType jinglePayloadType = (JinglePayloadType)iterator.next();
            if (!(jinglePayloadType instanceof JinglePayloadType.Audio)) continue;
            JinglePayloadType.Audio audio = (JinglePayloadType.Audio)jinglePayloadType;
            arrayList.add(audio.getPayloadType());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJinglePayloadTypesCount() {
        List list = this.payloads;
        synchronized (list) {
            return this.payloads.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        List list = this.payloads;
        synchronized (list) {
            if (this.payloads.size() > 0) {
                stringBuilder.append("<").append(this.getElementName());
                stringBuilder.append(" xmlns=\"").append(this.getNamespace()).append("\"");
                stringBuilder.append(" media=\"").append(this.getMediaType()).append("\" >");
                ListIterator listIterator = this.payloads.listIterator();
                while (listIterator.hasNext()) {
                    JinglePayloadType jinglePayloadType = (JinglePayloadType)listIterator.next();
                    stringBuilder.append(jinglePayloadType.toXML());
                }
                stringBuilder.append("</").append(this.getElementName()).append(">");
            }
        }
        return stringBuilder.toString();
    }

    public static class JinglePayloadType {
        public static final String NODENAME = "payload-type";
        private PayloadType payload;

        public JinglePayloadType(PayloadType payloadType) {
            this.payload = payloadType;
        }

        public JinglePayloadType() {
            this(null);
        }

        public static String getElementName() {
            return NODENAME;
        }

        public PayloadType getPayloadType() {
            return this.payload;
        }

        public void setPayload(PayloadType payloadType) {
            this.payload = payloadType;
        }

        protected String getChildAttributes() {
            return null;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.payload != null) {
                stringBuilder.append("<").append(JinglePayloadType.getElementName()).append(" ");
                if (this.payload.getId() != PayloadType.INVALID_PT) {
                    stringBuilder.append(" id=\"").append(this.payload.getId()).append("\"");
                }
                if (this.payload.getName() != null) {
                    stringBuilder.append(" name=\"").append(this.payload.getName()).append("\"");
                }
                if (this.payload.getChannels() != 0) {
                    stringBuilder.append(" channels=\"").append(this.payload.getChannels()).append("\"");
                }
                if (this.getChildAttributes() != null) {
                    stringBuilder.append(this.getChildAttributes());
                }
                stringBuilder.append("/>");
            }
            return stringBuilder.toString();
        }

        public static class Audio
        extends JinglePayloadType {
            public Audio(PayloadType.Audio audio) {
                super(audio);
            }

            @Override
            protected String getChildAttributes() {
                StringBuilder stringBuilder = new StringBuilder();
                PayloadType payloadType = this.getPayloadType();
                if (payloadType instanceof PayloadType.Audio) {
                    PayloadType.Audio audio = (PayloadType.Audio)payloadType;
                    stringBuilder.append(" clockrate=\"").append(audio.getClockRate()).append("\" ");
                }
                return stringBuilder.toString();
            }
        }
    }

    public static class Audio
    extends JingleContentDescription {
        public static final String NAMESPACE = "urn:xmpp:jingle:apps:rtp:1";
        public static final String MEDIA_TYPE = "audio";

        public Audio() {
        }

        public Audio(JinglePayloadType jinglePayloadType) {
            this.addJinglePayloadType(jinglePayloadType);
        }

        @Override
        public String getNamespace() {
            return NAMESPACE;
        }

        @Override
        public String getMediaType() {
            return MEDIA_TYPE;
        }
    }
}

