/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.ext.macros;

import java.io.Reader;
import java.io.StringReader;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.workgroup.ext.macros.Macro;
import org.jivesoftware.smackx.workgroup.ext.macros.MacroGroup;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class Macros
extends IQ {
    private MacroGroup rootGroup;
    private boolean personal;
    private MacroGroup personalMacroGroup;
    public static final String ELEMENT_NAME = "macros";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";

    public MacroGroup getRootGroup() {
        return this.rootGroup;
    }

    public void setRootGroup(MacroGroup macroGroup) {
        this.rootGroup = macroGroup;
    }

    public boolean isPersonal() {
        return this.personal;
    }

    public void setPersonal(boolean bl) {
        this.personal = bl;
    }

    public MacroGroup getPersonalMacroGroup() {
        return this.personalMacroGroup;
    }

    public void setPersonalMacroGroup(MacroGroup macroGroup) {
        this.personalMacroGroup = macroGroup;
    }

    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE).append("\">");
        if (this.isPersonal()) {
            stringBuilder.append("<personal>true</personal>");
        }
        if (this.getPersonalMacroGroup() != null) {
            stringBuilder.append("<personalMacro>");
            stringBuilder.append(StringUtils.escapeForXML(this.getPersonalMacroGroup().toXML()));
            stringBuilder.append("</personalMacro>");
        }
        stringBuilder.append("</").append(ELEMENT_NAME).append("> ");
        return stringBuilder.toString();
    }

    public static class InternalProvider
    implements IQProvider {
        public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
            Macros macros = new Macros();
            boolean bl = false;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2) {
                    if (!xmlPullParser.getName().equals("model")) continue;
                    String string = xmlPullParser.nextText();
                    MacroGroup macroGroup = this.parseMacroGroups(string);
                    macros.setRootGroup(macroGroup);
                    continue;
                }
                if (n != 3 || !xmlPullParser.getName().equals(Macros.ELEMENT_NAME)) continue;
                bl = true;
            }
            return macros;
        }

        public Macro parseMacro(XmlPullParser xmlPullParser) throws Exception {
            Macro macro = new Macro();
            boolean bl = false;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2) {
                    if (xmlPullParser.getName().equals("title")) {
                        xmlPullParser.next();
                        macro.setTitle(xmlPullParser.getText());
                        continue;
                    }
                    if (xmlPullParser.getName().equals("description")) {
                        macro.setDescription(xmlPullParser.nextText());
                        continue;
                    }
                    if (xmlPullParser.getName().equals("response")) {
                        macro.setResponse(xmlPullParser.nextText());
                        continue;
                    }
                    if (!xmlPullParser.getName().equals("type")) continue;
                    macro.setType(Integer.valueOf(xmlPullParser.nextText()));
                    continue;
                }
                if (n != 3 || !xmlPullParser.getName().equals("macro")) continue;
                bl = true;
            }
            return macro;
        }

        public MacroGroup parseMacroGroup(XmlPullParser xmlPullParser) throws Exception {
            MacroGroup macroGroup = new MacroGroup();
            boolean bl = false;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2) {
                    if (xmlPullParser.getName().equals("macrogroup")) {
                        macroGroup.addMacroGroup(this.parseMacroGroup(xmlPullParser));
                    }
                    if (xmlPullParser.getName().equals("title")) {
                        macroGroup.setTitle(xmlPullParser.nextText());
                    }
                    if (!xmlPullParser.getName().equals("macro")) continue;
                    macroGroup.addMacro(this.parseMacro(xmlPullParser));
                    continue;
                }
                if (n != 3 || !xmlPullParser.getName().equals("macrogroup")) continue;
                bl = true;
            }
            return macroGroup;
        }

        public MacroGroup parseMacroGroups(String string) throws Exception {
            MacroGroup macroGroup = null;
            XmlPullParser xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
            xmlPullParser.setInput((Reader)new StringReader(string));
            int n = xmlPullParser.getEventType();
            while (n != 1) {
                n = xmlPullParser.next();
                if (n != 2 || !xmlPullParser.getName().equals("macrogroup")) continue;
                macroGroup = this.parseMacroGroup(xmlPullParser);
            }
            return macroGroup;
        }
    }
}

