/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingle.ContentNegotiator;
import org.jivesoftware.smackx.jingle.JingleActionEnum;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.JingleSessionState;
import org.jivesoftware.smackx.jingle.JingleSessionStatePending;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.MediaNegotiator;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingle.nat.TransportNegotiator;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.packet.JingleContent;
import org.jivesoftware.smackx.packet.JingleDescription;
import org.jivesoftware.smackx.packet.JingleError;
import org.jivesoftware.smackx.packet.JingleTransport;

public class JingleSessionStateUnknown
extends JingleSessionState {
    private static JingleSessionStateUnknown INSTANCE = null;

    protected JingleSessionStateUnknown() {
    }

    public static synchronized JingleSessionState getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JingleSessionStateUnknown();
        }
        return INSTANCE;
    }

    @Override
    public void enter() {
    }

    @Override
    public void exit() {
    }

    @Override
    public IQ processJingle(JingleSession jingleSession, Jingle jingle, JingleActionEnum jingleActionEnum) {
        IQ iQ = null;
        switch (jingleActionEnum) {
            case SESSION_INITIATE: {
                iQ = this.receiveSessionInitiateAction(jingleSession, jingle);
                break;
            }
            case SESSION_TERMINATE: {
                iQ = this.receiveSessionTerminateAction(jingleSession, jingle);
                break;
            }
            default: {
                iQ = jingleSession.createJingleError(jingle, JingleError.MALFORMED_STANZA);
            }
        }
        return iQ;
    }

    private IQ receiveSessionInitiateAction(JingleSession jingleSession, Jingle jingle) {
        IQ iQ = null;
        boolean bl = true;
        if (!bl) {
            iQ = jingleSession.createJingleError(jingle, JingleError.NEGOTIATION_ERROR);
        } else {
            iQ = jingleSession.createAck(jingle);
            jingleSession.setSessionState(JingleSessionStatePending.getInstance());
            for (JingleContent jingleContent : jingle.getContentsList()) {
                ContentNegotiator contentNegotiator = new ContentNegotiator(jingleSession, jingleContent.getCreator(), jingleContent.getName());
                JingleDescription jingleDescription = jingleContent.getDescription();
                JingleMediaManager object = jingleSession.getMediaManagers().get(0);
                for (JingleMediaManager jingleMediaManager : jingleSession.getMediaManagers()) {
                    boolean bl2 = true;
                    for (PayloadType payloadType : jingleMediaManager.getPayloads()) {
                        for (PayloadType payloadType2 : jingleDescription.getPayloadTypesList()) {
                            if (payloadType.getId() == payloadType2.getId()) continue;
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        object = jingleMediaManager;
                    }
                }
                contentNegotiator.setMediaNegotiator(new MediaNegotiator(jingleSession, object, jingleDescription.getPayloadTypesList(), contentNegotiator));
                for (JingleTransport jingleTransport : jingleContent.getJingleTransportsList()) {
                    for (JingleMediaManager jingleMediaManager : jingleSession.getMediaManagers()) {
                        JingleTransportManager jingleTransportManager = jingleMediaManager.getTransportManager();
                        Object object2 = null;
                        try {
                            object2 = jingleTransportManager.getResolver(jingleSession);
                        }
                        catch (XMPPException xMPPException) {
                            xMPPException.printStackTrace();
                        }
                        if (((TransportResolver)object2).getType().equals((Object)TransportResolver.Type.rawupd)) {
                            contentNegotiator.setTransportNegotiator(new TransportNegotiator.RawUdp(jingleSession, (TransportResolver)object2, contentNegotiator));
                        }
                        if (!((TransportResolver)object2).getType().equals((Object)TransportResolver.Type.ice)) continue;
                        contentNegotiator.setTransportNegotiator(new TransportNegotiator.Ice(jingleSession, (TransportResolver)object2, contentNegotiator));
                    }
                }
                jingleSession.addContentNegotiator(contentNegotiator);
            }
            jingleSession.setupListeners();
        }
        return iQ;
    }

    private IQ receiveSessionTerminateAction(JingleSession jingleSession, Jingle jingle) {
        IQ iQ = jingleSession.createAck(jingle);
        try {
            jingleSession.terminate("Closed remotely");
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
        }
        return iQ;
    }
}

