package org.sipdroid.net.tools;

import java.util.ArrayList;

public abstract class ObjectPool<E> {  
	private ArrayList<Object> locked, unlocked;

	ObjectPool(int size){
		locked = new ArrayList<Object>(size);         
		unlocked = new ArrayList<Object>(size);
	}

	public int getPoolSize() {
		return locked.size() + unlocked.size();
	}

	abstract Object create();
	abstract boolean validate( Object o );
	synchronized Object checkOut(){     
		if(unlocked.size() > 0){
			Object cur = unlocked.get(0);
			unlocked.remove(cur);
			locked.add(cur);           
			return(cur);
		}      
		// no objects available, create a new one
		Object o = create();
		locked.add(o);
		return(o);
	}

	synchronized void checkIn( Object o ) {
		locked.remove( o );
		unlocked.add(o);
	}

}
