/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.jingle.ContentNegotiator;
import org.jivesoftware.smackx.jingle.JingleActionEnum;
import org.jivesoftware.smackx.jingle.JingleException;
import org.jivesoftware.smackx.jingle.JingleNegotiator;
import org.jivesoftware.smackx.jingle.JingleNegotiatorState;
import org.jivesoftware.smackx.jingle.JingleSessionRequest;
import org.jivesoftware.smackx.jingle.JingleSessionState;
import org.jivesoftware.smackx.jingle.JingleSessionStateActive;
import org.jivesoftware.smackx.jingle.JingleSessionStateEnded;
import org.jivesoftware.smackx.jingle.JingleSessionStatePending;
import org.jivesoftware.smackx.jingle.JingleSessionStateUnknown;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.listeners.JingleListener;
import org.jivesoftware.smackx.jingle.listeners.JingleMediaListener;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionListener;
import org.jivesoftware.smackx.jingle.listeners.JingleTransportListener;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.MediaNegotiator;
import org.jivesoftware.smackx.jingle.media.MediaReceivedListener;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportNegotiator;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.packet.JingleError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JingleSession
extends JingleNegotiator
implements MediaReceivedListener {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(JingleSession.class);
    private static final HashMap sessions = new HashMap();
    private static final Random randomGenerator = new Random();
    private String initiator;
    private String responder;
    private String sid;
    ConnectionListener connectionListener;
    PacketListener packetListener;
    PacketFilter packetFilter;
    protected List<JingleMediaManager> jingleMediaManagers = null;
    private boolean closed = false;
    private JingleSessionState sessionState;
    private List<ContentNegotiator> contentNegotiators;
    private JingleSessionRequest sessionRequest;
    private Connection connection;
    private String sessionInitPacketID;
    private Map<String, JingleMediaSession> mediaSessionMap;

    public JingleSession(Connection connection, String string, String string2, String string3, List<JingleMediaManager> list) {
        this.initiator = string;
        this.responder = string2;
        this.sid = string3;
        this.jingleMediaManagers = list;
        this.setSession(this);
        this.connection = connection;
        this.setSessionState(JingleSessionStateUnknown.getInstance());
        this.contentNegotiators = new ArrayList<ContentNegotiator>();
        this.mediaSessionMap = new HashMap<String, JingleMediaSession>();
        this.registerInstance();
        this.installConnectionListeners(connection);
    }

    public JingleSession(Connection connection, JingleSessionRequest jingleSessionRequest, String string, String string2, List<JingleMediaManager> list) {
        this(connection, string, string2, JingleSession.generateSessionId(), list);
        this.sessionRequest = jingleSessionRequest;
    }

    public String getInitiator() {
        return this.initiator;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public void setInitiator(String string) {
        this.initiator = string;
    }

    public List<JingleMediaManager> getMediaManagers() {
        return this.jingleMediaManagers;
    }

    public void setMediaManagers(List<JingleMediaManager> list) {
        this.jingleMediaManagers = list;
    }

    public String getResponder() {
        return this.responder;
    }

    public void setResponder(String string) {
        this.responder = string;
    }

    public String getSid() {
        return this.sid;
    }

    protected void setSid(String string) {
        this.sid = string;
    }

    protected static String generateSessionId() {
        return String.valueOf(Math.abs(randomGenerator.nextLong()));
    }

    public void setSessionState(JingleSessionState jingleSessionState) {
        LOGGER.debug("Session state change: " + this.sessionState + "->" + jingleSessionState);
        jingleSessionState.enter();
        this.sessionState = jingleSessionState;
    }

    public JingleSessionState getSessionState() {
        return this.sessionState;
    }

    public boolean isFullyEstablished() {
        boolean bl = true;
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            if (contentNegotiator.isFullyEstablished()) continue;
            bl = false;
        }
        return bl;
    }

    public synchronized void receivePacketAndRespond(IQ iQ) throws XMPPException {
        ArrayList<IQ> arrayList = new ArrayList<IQ>();
        String string = null;
        LOGGER.debug("Packet: " + iQ.toXML());
        try {
            arrayList.addAll(this.dispatchIncomingPacket(iQ, null));
            if (iQ != null) {
                string = iQ.getPacketID();
                for (ContentNegotiator object : this.contentNegotiators) {
                    if (!object.isStarted()) {
                        object.start();
                    }
                    arrayList.addAll(object.dispatchIncomingPacket(iQ, string));
                }
            }
        }
        catch (JingleException jingleException) {
            JingleError jingleError = jingleException.getError();
            if (jingleError != null) {
                arrayList.add(this.createJingleError(iQ, jingleError));
            }
            this.triggerSessionClosedOnError(jingleException);
        }
        for (IQ iQ2 : arrayList) {
            this.sendPacket(iQ2);
        }
    }

    @Override
    public List<IQ> dispatchIncomingPacket(IQ iQ, String string) throws XMPPException {
        ArrayList<IQ> arrayList = new ArrayList<IQ>();
        Packet packet = null;
        if (iQ != null && !iQ.getType().equals(IQ.Type.ERROR)) {
            if (iQ.getType().equals(IQ.Type.RESULT)) {
                if (this.isExpectedId(iQ.getPacketID())) {
                    if (iQ.getPacketID().equals(this.sessionInitPacketID)) {
                        this.startNegotiators();
                    }
                    this.removeExpectedId(iQ.getPacketID());
                }
            } else if (iQ instanceof Jingle) {
                Jingle jingle = (Jingle)iQ;
                JingleActionEnum jingleActionEnum = jingle.getAction();
                packet = this.getSessionState().processJingle(this, jingle, jingleActionEnum);
            }
        }
        if (packet != null) {
            this.addExpectedId(packet.getPacketID());
            arrayList.add((IQ)packet);
        }
        return arrayList;
    }

    public void addContentNegotiator(ContentNegotiator contentNegotiator) {
        this.contentNegotiators.add(contentNegotiator);
    }

    public void sendPacket(IQ iQ) {
        if (iQ instanceof Jingle) {
            this.sendFormattedJingle((Jingle)iQ);
        } else {
            this.getConnection().sendPacket(iQ);
        }
    }

    public Jingle sendFormattedJingle(Jingle jingle) {
        return this.sendFormattedJingle(null, jingle);
    }

    public Jingle sendFormattedJingle(IQ iQ, Jingle jingle) {
        if (jingle != null) {
            String string;
            if (jingle.getInitiator() == null) {
                jingle.setInitiator(this.getInitiator());
            }
            if (jingle.getResponder() == null) {
                jingle.setResponder(this.getResponder());
            }
            if (jingle.getSid() == null) {
                jingle.setSid(this.getSid());
            }
            String string2 = this.getConnection().getUser();
            String string3 = string = this.getResponder().equals(string2) ? this.getInitiator() : this.getResponder();
            if (jingle.getTo() == null) {
                if (iQ != null) {
                    jingle.setTo(iQ.getFrom());
                } else {
                    jingle.setTo(string);
                }
            }
            if (jingle.getFrom() == null) {
                if (iQ != null) {
                    jingle.setFrom(iQ.getTo());
                } else {
                    jingle.setFrom(string2);
                }
            }
            if (this.getConnection() != null && this.getConnection().isConnected()) {
                this.getConnection().sendPacket(jingle);
            }
        }
        return jingle;
    }

    private void sendPendingStateAction(Jingle jingle, JingleActionEnum jingleActionEnum) {
    }

    private void sendActiveStateAction(Jingle jingle, JingleActionEnum jingleActionEnum) {
    }

    private void sendEndedStateAction(Jingle jingle, JingleActionEnum jingleActionEnum) {
    }

    public IQ createAck(IQ iQ) {
        IQ iQ2 = null;
        if (iQ != null && iQ.getType().equals(IQ.Type.SET)) {
            IQ iQ3;
            iQ2 = iQ3 = JingleSession.createIQ(iQ.getPacketID(), iQ.getFrom(), iQ.getTo(), IQ.Type.RESULT);
        }
        return iQ2;
    }

    public int hashCode() {
        return Jingle.getSessionHash(this.getSid(), this.getInitiator());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JingleSession jingleSession = (JingleSession)object;
        if (this.initiator == null) {
            if (jingleSession.initiator != null) {
                return false;
            }
        } else if (!this.initiator.equals(jingleSession.initiator)) {
            // empty if block
        }
        if (this.responder == null ? jingleSession.responder != null : !this.responder.equals(jingleSession.responder)) {
            return false;
        }
        return !(this.sid == null ? jingleSession.sid != null : !this.sid.equals(jingleSession.sid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterInstanceFor(Connection connection) {
        HashMap hashMap = sessions;
        synchronized (hashMap) {
            sessions.remove(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInstance() {
        HashMap hashMap = sessions;
        synchronized (hashMap) {
            sessions.put(this.getConnection(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JingleSession getInstanceFor(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        JingleSession jingleSession = null;
        HashMap hashMap = sessions;
        synchronized (hashMap) {
            if (sessions.containsKey(connection)) {
                jingleSession = (JingleSession)sessions.get(connection);
            }
        }
        return jingleSession;
    }

    private void installConnectionListeners(final Connection connection) {
        if (connection != null) {
            this.connectionListener = new ConnectionListener(){

                public void connectionClosed() {
                    JingleSession.this.unregisterInstanceFor(connection);
                }

                public void connectionClosedOnError(Exception exception) {
                    JingleSession.this.unregisterInstanceFor(connection);
                }

                public void reconnectingIn(int n) {
                }

                public void reconnectionSuccessful() {
                }

                public void reconnectionFailed(Exception exception) {
                }
            };
            connection.addConnectionListener(this.connectionListener);
        }
    }

    private void removeConnectionListener() {
        if (this.connectionListener != null) {
            this.getConnection().removeConnectionListener(this.connectionListener);
            LOGGER.debug("JINGLE SESSION: REMOVE CONNECTION LISTENER");
        }
    }

    protected void removePacketListener() {
        if (this.packetListener != null) {
            this.getConnection().removePacketListener(this.packetListener);
            LOGGER.debug("JINGLE SESSION: REMOVE PACKET LISTENER");
        }
    }

    protected void updatePacketListener() {
        this.removePacketListener();
        LOGGER.debug("UpdatePacketListener");
        this.packetListener = new PacketListener(){

            public void processPacket(Packet packet) {
                try {
                    JingleSession.this.receivePacketAndRespond((IQ)packet);
                }
                catch (XMPPException xMPPException) {
                    xMPPException.printStackTrace();
                }
            }
        };
        this.packetFilter = new PacketFilter(){

            public boolean accept(Packet packet) {
                if (packet instanceof IQ) {
                    String string;
                    IQ iQ = (IQ)packet;
                    String string2 = JingleSession.this.getConnection().getUser();
                    if (!iQ.getTo().equals(string2)) {
                        return false;
                    }
                    String string3 = string = JingleSession.this.getResponder().equals(string2) ? JingleSession.this.getInitiator() : JingleSession.this.getResponder();
                    if (iQ.getFrom() == null || !iQ.getFrom().equals(string == null ? "" : string)) {
                        return false;
                    }
                    if (iQ instanceof Jingle) {
                        Jingle jingle = (Jingle)iQ;
                        String string4 = jingle.getSid();
                        if (string4 == null || !string4.equals(JingleSession.this.getSid())) {
                            LOGGER.debug("Ignored Jingle(SID) " + string4 + "|" + JingleSession.this.getSid() + " :" + iQ.toXML());
                            return false;
                        }
                        String string5 = jingle.getInitiator();
                        if (!string5.equals(JingleSession.this.getInitiator())) {
                            LOGGER.debug("Ignored Jingle(INI): " + iQ.toXML());
                            return false;
                        }
                    } else {
                        if (iQ.getType().equals(IQ.Type.SET)) {
                            LOGGER.debug("Ignored Jingle(TYPE): " + iQ.toXML());
                            return false;
                        }
                        if (iQ.getType().equals(IQ.Type.GET)) {
                            LOGGER.debug("Ignored Jingle(TYPE): " + iQ.toXML());
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        this.getConnection().addPacketListener(this.packetListener, this.packetFilter);
    }

    public void addMediaListener(JingleMediaListener jingleMediaListener) {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            if (contentNegotiator.getMediaNegotiator() == null) continue;
            contentNegotiator.getMediaNegotiator().addListener(jingleMediaListener);
        }
    }

    public void removeMediaListener(JingleMediaListener jingleMediaListener) {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            if (contentNegotiator.getMediaNegotiator() == null) continue;
            contentNegotiator.getMediaNegotiator().removeListener(jingleMediaListener);
        }
    }

    public void addTransportListener(JingleTransportListener jingleTransportListener) {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            if (contentNegotiator.getTransportNegotiator() == null) continue;
            contentNegotiator.getTransportNegotiator().addListener(jingleTransportListener);
        }
    }

    public void removeTransportListener(JingleTransportListener jingleTransportListener) {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            if (contentNegotiator.getTransportNegotiator() == null) continue;
            contentNegotiator.getTransportNegotiator().removeListener(jingleTransportListener);
        }
    }

    public void setupListeners() {
        JingleMediaListener jingleMediaListener = new JingleMediaListener(){

            public void mediaClosed(PayloadType payloadType) {
            }

            public void mediaEstablished(PayloadType payloadType) {
                if (JingleSession.this.isFullyEstablished()) {
                    Jingle jingle = new Jingle(JingleActionEnum.SESSION_ACCEPT);
                    for (ContentNegotiator contentNegotiator : JingleSession.this.contentNegotiators) {
                        if (contentNegotiator.getNegotiatorState() != JingleNegotiatorState.SUCCEEDED) continue;
                        jingle.addContent(contentNegotiator.getJingleContent());
                    }
                    JingleSession.this.addExpectedId(jingle.getPacketID());
                    JingleSession.this.sendPacket(jingle);
                }
            }
        };
        JingleTransportListener jingleTransportListener = new JingleTransportListener(){

            public void transportEstablished(TransportCandidate transportCandidate, TransportCandidate transportCandidate2) {
                if (JingleSession.this.isFullyEstablished()) {
                    JingleSession.this.setSessionState(JingleSessionStateActive.getInstance());
                    for (Object object : JingleSession.this.contentNegotiators) {
                        if (((ContentNegotiator)object).getNegotiatorState() != JingleNegotiatorState.SUCCEEDED) continue;
                        ((ContentNegotiator)object).triggerContentEstablished();
                    }
                    if (JingleSession.this.getSessionState().equals(JingleSessionStatePending.getInstance())) {
                        Jingle jingle = new Jingle(JingleActionEnum.SESSION_ACCEPT);
                        for (ContentNegotiator contentNegotiator : JingleSession.this.contentNegotiators) {
                            if (contentNegotiator.getNegotiatorState() != JingleNegotiatorState.SUCCEEDED) continue;
                            jingle.addContent(contentNegotiator.getJingleContent());
                        }
                        JingleSession.this.addExpectedId(jingle.getPacketID());
                        JingleSession.this.sendPacket(jingle);
                    }
                }
            }

            public void transportClosed(TransportCandidate transportCandidate) {
            }

            public void transportClosedOnError(XMPPException xMPPException) {
            }
        };
        this.addMediaListener(jingleMediaListener);
        this.addTransportListener(jingleTransportListener);
    }

    protected void triggerSessionClosed(String string) {
        List<JingleListener> list = this.getListenersList();
        for (JingleListener jingleListener : list) {
            if (!(jingleListener instanceof JingleSessionListener)) continue;
            JingleSessionListener jingleSessionListener = (JingleSessionListener)jingleListener;
            jingleSessionListener.sessionClosed(string, this);
        }
        this.close();
    }

    protected void triggerSessionClosedOnError(XMPPException xMPPException) {
        for (ContentNegotiator object2 : this.contentNegotiators) {
            object2.stopJingleMediaSession();
            for (TransportCandidate transportCandidate : object2.getTransportNegotiator().getOfferedCandidates()) {
                transportCandidate.removeCandidateEcho();
            }
        }
        List<JingleListener> list = this.getListenersList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JingleListener jingleListener = (JingleListener)iterator.next();
            if (!(jingleListener instanceof JingleSessionListener)) continue;
            JingleSessionListener jingleSessionListener = (JingleSessionListener)jingleListener;
            jingleSessionListener.sessionClosedOnError(xMPPException, this);
        }
        this.close();
    }

    protected void triggerMediaReceived(String string) {
        List<JingleListener> list = this.getListenersList();
        for (JingleListener jingleListener : list) {
            if (!(jingleListener instanceof JingleSessionListener)) continue;
            JingleSessionListener jingleSessionListener = (JingleSessionListener)jingleListener;
            jingleSessionListener.sessionMediaReceived(this, string);
        }
    }

    public void terminate() throws XMPPException {
        this.terminate("Closed Locally");
    }

    public void terminate(String string) throws XMPPException {
        if (this.isClosed()) {
            return;
        }
        LOGGER.debug("Terminate " + string);
        Jingle jingle = new Jingle(JingleActionEnum.SESSION_TERMINATE);
        jingle.setType(IQ.Type.SET);
        this.sendPacket(jingle);
        this.triggerSessionClosed(string);
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.setSessionState(JingleSessionStateEnded.getInstance());
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            contentNegotiator.stopJingleMediaSession();
            for (TransportCandidate transportCandidate : contentNegotiator.getTransportNegotiator().getOfferedCandidates()) {
                transportCandidate.removeCandidateEcho();
            }
            contentNegotiator.close();
        }
        this.removePacketListener();
        this.removeConnectionListener();
        this.getConnection().removeConnectionListener(this.connectionListener);
        LOGGER.debug("Negotiation Closed: " + this.getConnection().getUser() + " " + this.sid);
        super.close();
    }

    public boolean isClosed() {
        return this.getSessionState().equals(JingleSessionStateEnded.getInstance());
    }

    public static IQ createIQ(String string, String string2, String string3, IQ.Type type) {
        IQ iQ = new IQ(){

            public String getChildElementXML() {
                return null;
            }
        };
        iQ.setPacketID(string);
        iQ.setTo(string2);
        iQ.setFrom(string3);
        iQ.setType(type);
        return iQ;
    }

    public static IQ createError(String string, String string2, String string3, int n, XMPPError xMPPError) {
        IQ iQ = JingleSession.createIQ(string, string2, string3, IQ.Type.ERROR);
        iQ.setError(xMPPError);
        LOGGER.debug("Created Error Packet:" + iQ.toXML());
        return iQ;
    }

    public IQ createJingleError(IQ iQ, JingleError jingleError) {
        IQ iQ2 = null;
        if (jingleError != null) {
            iQ2 = JingleSession.createIQ(this.getSid(), iQ.getFrom(), iQ.getTo(), IQ.Type.ERROR);
            ArrayList<PacketExtension> arrayList = new ArrayList<PacketExtension>();
            arrayList.add(jingleError);
            XMPPError xMPPError = new XMPPError(0, XMPPError.Type.CANCEL, jingleError.toString(), "", arrayList);
            iQ2.setPacketID(iQ.getPacketID());
            iQ2.setError(xMPPError);
            LOGGER.error("Error sent: " + iQ2.toXML());
        }
        return iQ2;
    }

    @Override
    public void mediaReceived(String string) {
        this.triggerMediaReceived(string);
    }

    public void startOutgoing() throws IllegalStateException {
        this.updatePacketListener();
        this.setSessionState(JingleSessionStatePending.getInstance());
        Jingle jingle = new Jingle(JingleActionEnum.SESSION_INITIATE);
        for (JingleMediaManager object : this.getMediaManagers()) {
            ContentNegotiator contentNegotiator = new ContentNegotiator(this, "initiator", object.getName());
            contentNegotiator.setMediaNegotiator(new MediaNegotiator(this, object, object.getPayloads(), contentNegotiator));
            JingleTransportManager jingleTransportManager = object.getTransportManager();
            TransportResolver transportResolver = null;
            try {
                transportResolver = jingleTransportManager.getResolver(this);
            }
            catch (XMPPException xMPPException) {
                xMPPException.printStackTrace();
            }
            if (transportResolver.getType().equals((Object)TransportResolver.Type.rawupd)) {
                contentNegotiator.setTransportNegotiator(new TransportNegotiator.RawUdp(this, transportResolver, contentNegotiator));
            }
            if (transportResolver.getType().equals((Object)TransportResolver.Type.ice)) {
                contentNegotiator.setTransportNegotiator(new TransportNegotiator.Ice(this, transportResolver, contentNegotiator));
            }
            this.addContentNegotiator(contentNegotiator);
        }
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            jingle.addContent(contentNegotiator.getJingleContent());
        }
        this.sessionInitPacketID = jingle.getPacketID();
        this.sendPacket(jingle);
        this.setupListeners();
    }

    public void startIncoming() {
    }

    @Override
    protected void doStart() {
    }

    private void startNegotiators() {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            TransportNegotiator transportNegotiator = contentNegotiator.getTransportNegotiator();
            transportNegotiator.start();
        }
    }

    public void addJingleMediaSession(String string, JingleMediaSession jingleMediaSession) {
        this.mediaSessionMap.put(string, jingleMediaSession);
    }

    public JingleMediaSession getMediaSession(String string) {
        return this.mediaSessionMap.get(string);
    }
}

