/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Random;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.nat.RTPBridge;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;

public class BridgedResolver
extends TransportResolver {
    Connection connection;
    Random random = new Random();
    long sid;

    public BridgedResolver(Connection connection) {
        this.connection = connection;
    }

    public synchronized void resolve(JingleSession jingleSession) throws XMPPException {
        this.setResolveInit();
        this.clearCandidates();
        this.sid = Math.abs(this.random.nextLong());
        RTPBridge rTPBridge = RTPBridge.getRTPBridge(this.connection, String.valueOf(this.sid));
        String string = BridgedResolver.getLocalHost();
        TransportCandidate.Fixed fixed = new TransportCandidate.Fixed(rTPBridge.getIp(), rTPBridge.getPortA());
        fixed.setLocalIp(string);
        TransportCandidate.Fixed fixed2 = new TransportCandidate.Fixed(rTPBridge.getIp(), rTPBridge.getPortB());
        fixed2.setLocalIp(string);
        fixed.setSymmetric(fixed2);
        fixed2.setSymmetric(fixed);
        fixed.setPassword(rTPBridge.getPass());
        fixed2.setPassword(rTPBridge.getPass());
        fixed.setSessionId(rTPBridge.getSid());
        fixed2.setSessionId(rTPBridge.getSid());
        fixed.setConnection(this.connection);
        fixed2.setConnection(this.connection);
        this.addCandidate(fixed);
        this.setResolveEnd();
    }

    public void initialize() throws XMPPException {
        this.clearCandidates();
        if (!RTPBridge.serviceAvailable(this.connection)) {
            this.setInitialized();
            throw new XMPPException("No RTP Bridge service available");
        }
        this.setInitialized();
    }

    public void cancel() throws XMPPException {
    }

    public static String getLocalHost() {
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress() || inetAddress instanceof Inet6Address) continue;
                return inetAddress.getHostAddress();
            }
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "127.0.0.1";
        }
    }
}

