/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.provider;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.xmlpull.v1.XmlPullParser;

public class DelayInformationProvider
implements PacketExtensionProvider {
    private static final SimpleDateFormat XEP_0091_UTC_FALLBACK_FORMAT = new SimpleDateFormat("yyyyMd'T'HH:mm:ss");
    private static final SimpleDateFormat XEP_0082_UTC_FORMAT_WITHOUT_MILLIS;
    private static Map<String, DateFormat> formats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
        String string3;
        String string2 = xmlPullParser.getAttributeValue("", "stamp");
        Date date = null;
        DateFormat dateFormat = null;
        for (String string3 : formats.keySet()) {
            if (!string2.matches(string3)) continue;
            try {
                DateFormat dateFormat2 = dateFormat = formats.get(string3);
                synchronized (dateFormat2) {
                    date = dateFormat.parse(string2);
                }
            }
            catch (ParseException parseException) {}
            break;
        }
        if (dateFormat == DelayInformation.XEP_0091_UTC_FORMAT && string2.split("T")[0].length() < 8) {
            date = this.handleDateWithMissingLeadingZeros(string2);
        }
        if (date == null) {
            date = new Date();
        }
        DelayInformation delayInformation = new DelayInformation(date);
        delayInformation.setFrom(xmlPullParser.getAttributeValue("", "from"));
        string3 = xmlPullParser.nextText();
        string3 = "".equals(string3) ? null : string3;
        delayInformation.setReason(string3);
        return delayInformation;
    }

    private Date handleDateWithMissingLeadingZeros(String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Calendar calendar = null;
        Calendar calendar2 = null;
        calendar = this.parseXEP91Date(string, DelayInformation.XEP_0091_UTC_FORMAT);
        calendar2 = this.parseXEP91Date(string, XEP_0091_UTC_FALLBACK_FORMAT);
        List<Calendar> list = this.filterDatesBefore(gregorianCalendar, calendar, calendar2);
        if (!list.isEmpty()) {
            return this.determineNearestDate(gregorianCalendar, list).getTime();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Calendar parseXEP91Date(String string, DateFormat dateFormat) {
        try {
            DateFormat dateFormat2 = dateFormat;
            synchronized (dateFormat2) {
                dateFormat.parse(string);
                return dateFormat.getCalendar();
            }
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private List<Calendar> filterDatesBefore(Calendar calendar, Calendar ... calendarArray) {
        ArrayList<Calendar> arrayList = new ArrayList<Calendar>();
        for (Calendar calendar2 : calendarArray) {
            if (calendar2 == null || !calendar2.before(calendar)) continue;
            arrayList.add(calendar2);
        }
        return arrayList;
    }

    private Calendar determineNearestDate(final Calendar calendar, List<Calendar> list) {
        Collections.sort(list, new Comparator<Calendar>(){

            @Override
            public int compare(Calendar calendar3, Calendar calendar2) {
                Long l = new Long(calendar.getTimeInMillis() - calendar3.getTimeInMillis());
                Long l2 = new Long(calendar.getTimeInMillis() - calendar2.getTimeInMillis());
                return l.compareTo(l2);
            }
        });
        return list.get(0);
    }

    static {
        XEP_0091_UTC_FALLBACK_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        XEP_0082_UTC_FORMAT_WITHOUT_MILLIS = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        XEP_0082_UTC_FORMAT_WITHOUT_MILLIS.setTimeZone(TimeZone.getTimeZone("UTC"));
        formats = new HashMap<String, DateFormat>();
        formats.put("^\\d+T\\d+:\\d+:\\d+$", DelayInformation.XEP_0091_UTC_FORMAT);
        formats.put("^\\d+-\\d+-\\d+T\\d+:\\d+:\\d+\\.\\d+Z$", StringUtils.XEP_0082_UTC_FORMAT);
        formats.put("^\\d+-\\d+-\\d+T\\d+:\\d+:\\d+Z$", XEP_0082_UTC_FORMAT_WITHOUT_MILLIS);
    }
}

