/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jivesoftware.smackx.jingle.SmackLogger;

public class TcpUdpBridgeServer {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(TcpUdpBridgeServer.class);
    private String remoteTcpHost = null;
    private String remoteUdpHost = null;
    private int remoteTcpPort = -1;
    private int remoteUdpPort = -1;
    private int localUdpPort = -1;
    private DatagramSocket localUdpSocket;
    private Socket localTcpSocket;
    private ServerSocket serverTcpSocket;

    public TcpUdpBridgeServer(String string, String string2, int n, int n2) {
        this.remoteTcpHost = string;
        this.remoteUdpHost = string2;
        this.remoteTcpPort = n;
        this.remoteUdpPort = n2;
        try {
            this.serverTcpSocket = new ServerSocket(n);
            this.localUdpSocket = new DatagramSocket(0);
            this.localUdpPort = this.localUdpSocket.getLocalPort();
            LOGGER.debug("UDP: " + this.localUdpSocket.getLocalPort());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.startBridge();
    }

    public void startBridge() {
        final Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OutputStream outputStream = TcpUdpBridgeServer.this.localTcpSocket.getOutputStream();
                    while (true) {
                        byte[] byArray = new byte[500];
                        DatagramPacket datagramPacket = new DatagramPacket(byArray, 500);
                        TcpUdpBridgeServer.this.localUdpSocket.receive(datagramPacket);
                        if (datagramPacket.getLength() == 0) continue;
                        LOGGER.debug("UDP Server Received and Sending to TCP Client:" + new String(datagramPacket.getData(), 0, datagramPacket.getLength(), "UTF-8"));
                        outputStream.write(datagramPacket.getData(), 0, datagramPacket.getLength());
                        outputStream.flush();
                        LOGGER.debug("Server Flush");
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TcpUdpBridgeServer.this.localTcpSocket = TcpUdpBridgeServer.this.serverTcpSocket.accept();
                    thread.start();
                    InputStream inputStream = TcpUdpBridgeServer.this.localTcpSocket.getInputStream();
                    InetAddress inetAddress = InetAddress.getByName(TcpUdpBridgeServer.this.remoteUdpHost);
                    while (true) {
                        byte[] byArray = new byte[500];
                        int n = inputStream.read(byArray);
                        LOGGER.debug("TCP Server:" + new String(byArray, 0, n, "UTF-8"));
                        DatagramPacket datagramPacket = new DatagramPacket(byArray, n);
                        datagramPacket.setAddress(inetAddress);
                        datagramPacket.setPort(TcpUdpBridgeServer.this.remoteUdpPort);
                        TcpUdpBridgeServer.this.localUdpSocket.send(datagramPacket);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
            }
        }).start();
    }

    public Socket getLocalTcpSocket() {
        return this.localTcpSocket;
    }

    public DatagramSocket getLocalUdpSocket() {
        return this.localUdpSocket;
    }
}

