/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public abstract class Packet {
    protected static final String DEFAULT_LANGUAGE = Locale.getDefault().getLanguage().toLowerCase();
    private static String DEFAULT_XML_NS = null;
    public static final String ID_NOT_AVAILABLE = "ID_NOT_AVAILABLE";
    public static final DateFormat XEP_0082_UTC_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static String prefix;
    private static long id;
    private String xmlns = DEFAULT_XML_NS;
    private String packetID = null;
    private String to = null;
    private String from = null;
    private final List<PacketExtension> packetExtensions = new CopyOnWriteArrayList<PacketExtension>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private XMPPError error = null;

    public static synchronized String nextID() {
        return prefix + Long.toString(id++);
    }

    public static void setDefaultXmlns(String string) {
        DEFAULT_XML_NS = string;
    }

    public String getPacketID() {
        if (ID_NOT_AVAILABLE.equals(this.packetID)) {
            return null;
        }
        if (this.packetID == null) {
            this.packetID = Packet.nextID();
        }
        return this.packetID;
    }

    public void setPacketID(String string) {
        this.packetID = string;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String string) {
        this.to = string;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public XMPPError getError() {
        return this.error;
    }

    public void setError(XMPPError xMPPError) {
        this.error = xMPPError;
    }

    public synchronized Collection<PacketExtension> getExtensions() {
        if (this.packetExtensions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<PacketExtension>(this.packetExtensions));
    }

    public PacketExtension getExtension(String string) {
        return this.getExtension(null, string);
    }

    public PacketExtension getExtension(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        for (PacketExtension packetExtension : this.packetExtensions) {
            if (string != null && !string.equals(packetExtension.getElementName()) || !string2.equals(packetExtension.getNamespace())) continue;
            return packetExtension;
        }
        return null;
    }

    public void addExtension(PacketExtension packetExtension) {
        this.packetExtensions.add(packetExtension);
    }

    public void removeExtension(PacketExtension packetExtension) {
        this.packetExtensions.remove(packetExtension);
    }

    public synchronized Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public synchronized void setProperty(String string, Object object) {
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException("Value must be serialiazble");
        }
        this.properties.put(string, object);
    }

    public synchronized void deleteProperty(String string) {
        if (this.properties == null) {
            return;
        }
        this.properties.remove(string);
    }

    public synchronized Collection<String> getPropertyNames() {
        if (this.properties == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<String>(this.properties.keySet()));
    }

    public abstract String toXML();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized String getExtensionsXML() {
        StringBuilder stringBuilder = new StringBuilder();
        for (PacketExtension object : this.getExtensions()) {
            stringBuilder.append(object.toXML());
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            stringBuilder.append("<properties xmlns=\"http://www.jivesoftware.com/xmlns/xmpp/properties\">");
            for (String string : this.getPropertyNames()) {
                Object object = this.getProperty(string);
                stringBuilder.append("<property>");
                stringBuilder.append("<name>").append(StringUtils.escapeForXML(string)).append("</name>");
                stringBuilder.append("<value type=\"");
                if (object instanceof Integer) {
                    stringBuilder.append("integer\">").append(object).append("</value>");
                } else if (object instanceof Long) {
                    stringBuilder.append("long\">").append(object).append("</value>");
                } else if (object instanceof Float) {
                    stringBuilder.append("float\">").append(object).append("</value>");
                } else if (object instanceof Double) {
                    stringBuilder.append("double\">").append(object).append("</value>");
                } else if (object instanceof Boolean) {
                    stringBuilder.append("boolean\">").append(object).append("</value>");
                } else if (object instanceof String) {
                    stringBuilder.append("string\">");
                    stringBuilder.append(StringUtils.escapeForXML((String)object));
                    stringBuilder.append("</value>");
                } else {
                    ByteArrayOutputStream byteArrayOutputStream = null;
                    ObjectOutputStream objectOutputStream = null;
                    try {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        objectOutputStream.writeObject(object);
                        stringBuilder.append("java-object\">");
                        String string2 = StringUtils.encodeBase64(byteArrayOutputStream.toByteArray());
                        stringBuilder.append(string2).append("</value>");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        if (objectOutputStream != null) {
                            try {
                                objectOutputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (byteArrayOutputStream != null) {
                            try {
                                byteArrayOutputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                stringBuilder.append("</property>");
            }
            stringBuilder.append("</properties>");
        }
        return stringBuilder.toString();
    }

    public String getXmlns() {
        return this.xmlns;
    }

    public static String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Packet packet = (Packet)object;
        if (this.error != null ? !this.error.equals(packet.error) : packet.error != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(packet.from) : packet.from != null) {
            return false;
        }
        if (!((Object)this.packetExtensions).equals(packet.packetExtensions)) {
            return false;
        }
        if (this.packetID != null ? !this.packetID.equals(packet.packetID) : packet.packetID != null) {
            return false;
        }
        if (this.properties != null ? !((Object)this.properties).equals(packet.properties) : packet.properties != null) {
            return false;
        }
        if (this.to != null ? !this.to.equals(packet.to) : packet.to != null) {
            return false;
        }
        return !(this.xmlns == null ? packet.xmlns != null : !this.xmlns.equals(packet.xmlns));
    }

    public int hashCode() {
        int n = this.xmlns != null ? this.xmlns.hashCode() : 0;
        n = 31 * n + (this.packetID != null ? this.packetID.hashCode() : 0);
        n = 31 * n + (this.to != null ? this.to.hashCode() : 0);
        n = 31 * n + (this.from != null ? this.from.hashCode() : 0);
        n = 31 * n + ((Object)this.packetExtensions).hashCode();
        n = 31 * n + ((Object)this.properties).hashCode();
        n = 31 * n + (this.error != null ? this.error.hashCode() : 0);
        return n;
    }

    static {
        XEP_0082_UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        prefix = StringUtils.randomString(5) + "-";
        id = 0L;
    }
}

