/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Header;
import org.xbill.DNS.KEYBase;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.Mnemonic;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SIGBase;
import org.xbill.DNS.SIGRecord;

public class DNSSEC {
    private static final int ASN1_SEQ = 48;
    private static final int ASN1_INT = 2;
    private static final int DSA_LEN = 20;

    private DNSSEC() {
    }

    private static void digestSIG(DNSOutput dNSOutput, SIGBase sIGBase) {
        dNSOutput.writeU16(sIGBase.getTypeCovered());
        dNSOutput.writeU8(sIGBase.getAlgorithm());
        dNSOutput.writeU8(sIGBase.getLabels());
        dNSOutput.writeU32(sIGBase.getOrigTTL());
        dNSOutput.writeU32(sIGBase.getExpire().getTime() / 1000L);
        dNSOutput.writeU32(sIGBase.getTimeSigned().getTime() / 1000L);
        dNSOutput.writeU16(sIGBase.getFootprint());
        sIGBase.getSigner().toWireCanonical(dNSOutput);
    }

    public static byte[] digestRRset(RRSIGRecord rRSIGRecord, RRset rRset) {
        DNSOutput dNSOutput = new DNSOutput();
        DNSSEC.digestSIG(dNSOutput, rRSIGRecord);
        int n = rRset.size();
        Object[] objectArray = new Record[n];
        Iterator iterator = rRset.rrs();
        Name name = rRset.getName();
        Name name2 = null;
        int n2 = rRSIGRecord.getLabels() + 1;
        if (name.labels() > n2) {
            name2 = name.wild(name.labels() - n2);
        }
        while (iterator.hasNext()) {
            objectArray[--n] = (Record)iterator.next();
        }
        Arrays.sort(objectArray);
        DNSOutput dNSOutput2 = new DNSOutput();
        if (name2 != null) {
            name2.toWireCanonical(dNSOutput2);
        } else {
            name.toWireCanonical(dNSOutput2);
        }
        dNSOutput2.writeU16(rRset.getType());
        dNSOutput2.writeU16(rRset.getDClass());
        dNSOutput2.writeU32(rRSIGRecord.getOrigTTL());
        for (int i = 0; i < objectArray.length; ++i) {
            dNSOutput.writeByteArray(dNSOutput2.toByteArray());
            int n3 = dNSOutput.current();
            dNSOutput.writeU16(0);
            dNSOutput.writeByteArray(((Record)objectArray[i]).rdataToWireCanonical());
            int n4 = dNSOutput.current() - n3 - 2;
            dNSOutput.save();
            dNSOutput.jump(n3);
            dNSOutput.writeU16(n4);
            dNSOutput.restore();
        }
        return dNSOutput.toByteArray();
    }

    public static byte[] digestMessage(SIGRecord sIGRecord, Message message, byte[] byArray) {
        DNSOutput dNSOutput = new DNSOutput();
        DNSSEC.digestSIG(dNSOutput, sIGRecord);
        if (byArray != null) {
            dNSOutput.writeByteArray(byArray);
        }
        message.toWire(dNSOutput);
        return dNSOutput.toByteArray();
    }

    private static int BigIntegerLength(BigInteger bigInteger) {
        return (bigInteger.bitLength() + 7) / 8;
    }

    private static BigInteger readBigInteger(DNSInput dNSInput, int n) throws IOException {
        byte[] byArray = dNSInput.readByteArray(n);
        return new BigInteger(1, byArray);
    }

    private static BigInteger readBigInteger(DNSInput dNSInput) {
        byte[] byArray = dNSInput.readByteArray();
        return new BigInteger(1, byArray);
    }

    private static void writeBigInteger(DNSOutput dNSOutput, BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            dNSOutput.writeByteArray(byArray, 1, byArray.length - 1);
        } else {
            dNSOutput.writeByteArray(byArray);
        }
    }

    private static PublicKey toRSAPublicKey(KEYBase kEYBase) throws IOException, GeneralSecurityException {
        DNSInput dNSInput = new DNSInput(kEYBase.getKey());
        int n = dNSInput.readU8();
        if (n == 0) {
            n = dNSInput.readU16();
        }
        BigInteger bigInteger = DNSSEC.readBigInteger(dNSInput, n);
        BigInteger bigInteger2 = DNSSEC.readBigInteger(dNSInput);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(new RSAPublicKeySpec(bigInteger2, bigInteger));
    }

    private static PublicKey toDSAPublicKey(KEYBase kEYBase) throws IOException, GeneralSecurityException, MalformedKeyException {
        DNSInput dNSInput = new DNSInput(kEYBase.getKey());
        int n = dNSInput.readU8();
        if (n > 8) {
            throw new MalformedKeyException(kEYBase);
        }
        BigInteger bigInteger = DNSSEC.readBigInteger(dNSInput, 20);
        BigInteger bigInteger2 = DNSSEC.readBigInteger(dNSInput, 64 + n * 8);
        BigInteger bigInteger3 = DNSSEC.readBigInteger(dNSInput, 64 + n * 8);
        BigInteger bigInteger4 = DNSSEC.readBigInteger(dNSInput, 64 + n * 8);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        return keyFactory.generatePublic(new DSAPublicKeySpec(bigInteger4, bigInteger2, bigInteger, bigInteger3));
    }

    static PublicKey toPublicKey(KEYBase kEYBase) throws DNSSECException {
        int n = kEYBase.getAlgorithm();
        try {
            switch (n) {
                case 1: 
                case 5: 
                case 7: 
                case 8: 
                case 10: {
                    return DNSSEC.toRSAPublicKey(kEYBase);
                }
                case 3: 
                case 6: {
                    return DNSSEC.toDSAPublicKey(kEYBase);
                }
            }
            throw new UnsupportedAlgorithmException(n);
        }
        catch (IOException iOException) {
            throw new MalformedKeyException(kEYBase);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new DNSSECException(generalSecurityException.toString());
        }
    }

    private static byte[] fromRSAPublicKey(RSAPublicKey rSAPublicKey) {
        DNSOutput dNSOutput = new DNSOutput();
        BigInteger bigInteger = rSAPublicKey.getPublicExponent();
        BigInteger bigInteger2 = rSAPublicKey.getModulus();
        int n = DNSSEC.BigIntegerLength(bigInteger);
        if (n < 256) {
            dNSOutput.writeU8(n);
        } else {
            dNSOutput.writeU8(0);
            dNSOutput.writeU16(n);
        }
        DNSSEC.writeBigInteger(dNSOutput, bigInteger);
        DNSSEC.writeBigInteger(dNSOutput, bigInteger2);
        return dNSOutput.toByteArray();
    }

    private static byte[] fromDSAPublicKey(DSAPublicKey dSAPublicKey) {
        DNSOutput dNSOutput = new DNSOutput();
        BigInteger bigInteger = dSAPublicKey.getParams().getQ();
        BigInteger bigInteger2 = dSAPublicKey.getParams().getP();
        BigInteger bigInteger3 = dSAPublicKey.getParams().getG();
        BigInteger bigInteger4 = dSAPublicKey.getY();
        int n = (bigInteger2.toByteArray().length - 64) / 8;
        dNSOutput.writeU8(n);
        DNSSEC.writeBigInteger(dNSOutput, bigInteger);
        DNSSEC.writeBigInteger(dNSOutput, bigInteger2);
        DNSSEC.writeBigInteger(dNSOutput, bigInteger3);
        DNSSEC.writeBigInteger(dNSOutput, bigInteger4);
        return dNSOutput.toByteArray();
    }

    static byte[] fromPublicKey(PublicKey publicKey, int n) throws DNSSECException {
        Object var2_2 = null;
        switch (n) {
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                if (!(publicKey instanceof RSAPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromRSAPublicKey((RSAPublicKey)publicKey);
            }
            case 3: 
            case 6: {
                if (!(publicKey instanceof DSAPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromDSAPublicKey((DSAPublicKey)publicKey);
            }
        }
        throw new UnsupportedAlgorithmException(n);
    }

    public static String algString(int n) throws UnsupportedAlgorithmException {
        switch (n) {
            case 1: {
                return "MD5withRSA";
            }
            case 3: 
            case 6: {
                return "SHA1withDSA";
            }
            case 5: 
            case 7: {
                return "SHA1withRSA";
            }
            case 8: {
                return "SHA256withRSA";
            }
            case 10: {
                return "SHA512withRSA";
            }
        }
        throw new UnsupportedAlgorithmException(n);
    }

    private static byte[] DSASignaturefromDNS(byte[] byArray) throws DNSSECException, IOException {
        if (byArray.length != 41) {
            throw new SignatureVerificationException();
        }
        DNSInput dNSInput = new DNSInput(byArray);
        DNSOutput dNSOutput = new DNSOutput();
        int n = dNSInput.readU8();
        byte[] byArray2 = dNSInput.readByteArray(20);
        int n2 = 20;
        if (byArray2[0] < 0) {
            ++n2;
        }
        byte[] byArray3 = dNSInput.readByteArray(20);
        int n3 = 20;
        if (byArray3[0] < 0) {
            ++n3;
        }
        dNSOutput.writeU8(48);
        dNSOutput.writeU8(n2 + n3 + 4);
        dNSOutput.writeU8(2);
        dNSOutput.writeU8(n2);
        if (n2 > 20) {
            dNSOutput.writeU8(0);
        }
        dNSOutput.writeByteArray(byArray2);
        dNSOutput.writeU8(2);
        dNSOutput.writeU8(n3);
        if (n3 > 20) {
            dNSOutput.writeU8(0);
        }
        dNSOutput.writeByteArray(byArray3);
        return dNSOutput.toByteArray();
    }

    private static byte[] DSASignaturetoDNS(byte[] byArray, int n) throws IOException {
        DNSInput dNSInput = new DNSInput(byArray);
        DNSOutput dNSOutput = new DNSOutput();
        dNSOutput.writeU8(n);
        int n2 = dNSInput.readU8();
        if (n2 != 48) {
            throw new IOException();
        }
        int n3 = dNSInput.readU8();
        n2 = dNSInput.readU8();
        if (n2 != 2) {
            throw new IOException();
        }
        int n4 = dNSInput.readU8();
        if (n4 == 21 ? dNSInput.readU8() != 0 : n4 != 20) {
            throw new IOException();
        }
        byte[] byArray2 = dNSInput.readByteArray(20);
        dNSOutput.writeByteArray(byArray2);
        n2 = dNSInput.readU8();
        if (n2 != 2) {
            throw new IOException();
        }
        int n5 = dNSInput.readU8();
        if (n5 == 21 ? dNSInput.readU8() != 0 : n5 != 20) {
            throw new IOException();
        }
        byArray2 = dNSInput.readByteArray(20);
        dNSOutput.writeByteArray(byArray2);
        return dNSOutput.toByteArray();
    }

    private static void verify(PublicKey publicKey, int n, byte[] byArray, byte[] byArray2) throws DNSSECException {
        if (publicKey instanceof DSAPublicKey) {
            try {
                byArray2 = DNSSEC.DSASignaturefromDNS(byArray2);
            }
            catch (IOException iOException) {
                throw new IllegalStateException();
            }
        }
        try {
            Signature signature = Signature.getInstance(DNSSEC.algString(n));
            signature.initVerify(publicKey);
            signature.update(byArray);
            if (!signature.verify(byArray2)) {
                throw new SignatureVerificationException();
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new DNSSECException(generalSecurityException.toString());
        }
    }

    private static boolean matches(SIGBase sIGBase, KEYBase kEYBase) {
        return kEYBase.getAlgorithm() == sIGBase.getAlgorithm() && kEYBase.getFootprint() == sIGBase.getFootprint() && kEYBase.getName().equals(sIGBase.getSigner());
    }

    public static void verify(RRset rRset, RRSIGRecord rRSIGRecord, DNSKEYRecord dNSKEYRecord) throws DNSSECException {
        if (!DNSSEC.matches(rRSIGRecord, dNSKEYRecord)) {
            throw new KeyMismatchException(dNSKEYRecord, rRSIGRecord);
        }
        Date date = new Date();
        if (date.compareTo(rRSIGRecord.getExpire()) > 0) {
            throw new SignatureExpiredException(rRSIGRecord.getExpire(), date);
        }
        if (date.compareTo(rRSIGRecord.getTimeSigned()) < 0) {
            throw new SignatureNotYetValidException(rRSIGRecord.getTimeSigned(), date);
        }
        DNSSEC.verify(dNSKEYRecord.getPublicKey(), rRSIGRecord.getAlgorithm(), DNSSEC.digestRRset(rRSIGRecord, rRset), rRSIGRecord.getSignature());
    }

    private static byte[] sign(PrivateKey privateKey, PublicKey publicKey, int n, byte[] byArray, String string) throws DNSSECException {
        byte[] byArray2;
        Object object;
        try {
            object = string != null ? Signature.getInstance(DNSSEC.algString(n), string) : Signature.getInstance(DNSSEC.algString(n));
            ((Signature)object).initSign(privateKey);
            ((Signature)object).update(byArray);
            byArray2 = ((Signature)object).sign();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new DNSSECException(generalSecurityException.toString());
        }
        if (publicKey instanceof DSAPublicKey) {
            try {
                object = (DSAPublicKey)publicKey;
                BigInteger bigInteger = object.getParams().getP();
                int n2 = (DNSSEC.BigIntegerLength(bigInteger) - 64) / 8;
                byArray2 = DNSSEC.DSASignaturetoDNS(byArray2, n2);
            }
            catch (IOException iOException) {
                throw new IllegalStateException();
            }
        }
        return byArray2;
    }

    static void checkAlgorithm(PrivateKey privateKey, int n) throws UnsupportedAlgorithmException {
        switch (n) {
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                if (privateKey instanceof RSAPrivateKey) break;
                throw new IncompatibleKeyException();
            }
            case 3: 
            case 6: {
                if (privateKey instanceof DSAPrivateKey) break;
                throw new IncompatibleKeyException();
            }
            default: {
                throw new UnsupportedAlgorithmException(n);
            }
        }
    }

    public static RRSIGRecord sign(RRset rRset, DNSKEYRecord dNSKEYRecord, PrivateKey privateKey, Date date, Date date2) throws DNSSECException {
        return DNSSEC.sign(rRset, dNSKEYRecord, privateKey, date, date2, null);
    }

    public static RRSIGRecord sign(RRset rRset, DNSKEYRecord dNSKEYRecord, PrivateKey privateKey, Date date, Date date2, String string) throws DNSSECException {
        int n = dNSKEYRecord.getAlgorithm();
        DNSSEC.checkAlgorithm(privateKey, n);
        RRSIGRecord rRSIGRecord = new RRSIGRecord(rRset.getName(), rRset.getDClass(), rRset.getTTL(), rRset.getType(), n, rRset.getTTL(), date2, date, dNSKEYRecord.getFootprint(), dNSKEYRecord.getName(), null);
        rRSIGRecord.setSignature(DNSSEC.sign(privateKey, dNSKEYRecord.getPublicKey(), n, DNSSEC.digestRRset(rRSIGRecord, rRset), string));
        return rRSIGRecord;
    }

    static SIGRecord signMessage(Message message, SIGRecord sIGRecord, KEYRecord kEYRecord, PrivateKey privateKey, Date date, Date date2) throws DNSSECException {
        int n = kEYRecord.getAlgorithm();
        DNSSEC.checkAlgorithm(privateKey, n);
        SIGRecord sIGRecord2 = new SIGRecord(Name.root, 255, 0L, 0, n, 0L, date2, date, kEYRecord.getFootprint(), kEYRecord.getName(), null);
        DNSOutput dNSOutput = new DNSOutput();
        DNSSEC.digestSIG(dNSOutput, sIGRecord2);
        if (sIGRecord != null) {
            dNSOutput.writeByteArray(sIGRecord.getSignature());
        }
        message.toWire(dNSOutput);
        sIGRecord2.setSignature(DNSSEC.sign(privateKey, kEYRecord.getPublicKey(), n, dNSOutput.toByteArray(), null));
        return sIGRecord2;
    }

    static void verifyMessage(Message message, byte[] byArray, SIGRecord sIGRecord, SIGRecord sIGRecord2, KEYRecord kEYRecord) throws DNSSECException {
        if (!DNSSEC.matches(sIGRecord, kEYRecord)) {
            throw new KeyMismatchException(kEYRecord, sIGRecord);
        }
        Date date = new Date();
        if (date.compareTo(sIGRecord.getExpire()) > 0) {
            throw new SignatureExpiredException(sIGRecord.getExpire(), date);
        }
        if (date.compareTo(sIGRecord.getTimeSigned()) < 0) {
            throw new SignatureNotYetValidException(sIGRecord.getTimeSigned(), date);
        }
        DNSOutput dNSOutput = new DNSOutput();
        DNSSEC.digestSIG(dNSOutput, sIGRecord);
        if (sIGRecord2 != null) {
            dNSOutput.writeByteArray(sIGRecord2.getSignature());
        }
        Header header = (Header)message.getHeader().clone();
        header.decCount(3);
        dNSOutput.writeByteArray(header.toWire());
        dNSOutput.writeByteArray(byArray, 12, message.sig0start - 12);
        DNSSEC.verify(kEYRecord.getPublicKey(), sIGRecord.getAlgorithm(), dNSOutput.toByteArray(), sIGRecord.getSignature());
    }

    static byte[] generateDSDigest(DNSKEYRecord dNSKEYRecord, int n) {
        MessageDigest messageDigest;
        try {
            switch (n) {
                case 1: {
                    messageDigest = MessageDigest.getInstance("sha-1");
                    break;
                }
                case 2: {
                    messageDigest = MessageDigest.getInstance("sha-256");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown DS digest type " + n);
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("no message digest support");
        }
        messageDigest.update(dNSKEYRecord.getName().toWire());
        messageDigest.update(dNSKEYRecord.rdataToWireCanonical());
        return messageDigest.digest();
    }

    public static class IncompatibleKeyException
    extends IllegalArgumentException {
        IncompatibleKeyException() {
            super("incompatible keys");
        }
    }

    public static class SignatureVerificationException
    extends DNSSECException {
        SignatureVerificationException() {
            super("signature verification failed");
        }
    }

    public static class SignatureNotYetValidException
    extends DNSSECException {
        private Date when;
        private Date now;

        SignatureNotYetValidException(Date date, Date date2) {
            super("signature is not yet valid");
            this.when = date;
            this.now = date2;
        }

        public Date getExpiration() {
            return this.when;
        }

        public Date getVerifyTime() {
            return this.now;
        }
    }

    public static class SignatureExpiredException
    extends DNSSECException {
        private Date when;
        private Date now;

        SignatureExpiredException(Date date, Date date2) {
            super("signature expired");
            this.when = date;
            this.now = date2;
        }

        public Date getExpiration() {
            return this.when;
        }

        public Date getVerifyTime() {
            return this.now;
        }
    }

    public static class KeyMismatchException
    extends DNSSECException {
        private KEYBase key;
        private SIGBase sig;

        KeyMismatchException(KEYBase kEYBase, SIGBase sIGBase) {
            super("key " + kEYBase.getName() + "/" + Algorithm.string(kEYBase.getAlgorithm()) + "/" + kEYBase.getFootprint() + " " + "does not match signature " + sIGBase.getSigner() + "/" + Algorithm.string(sIGBase.getAlgorithm()) + "/" + sIGBase.getFootprint());
        }
    }

    public static class MalformedKeyException
    extends DNSSECException {
        MalformedKeyException(KEYBase kEYBase) {
            super("Invalid key data: " + kEYBase.rdataToString());
        }
    }

    public static class UnsupportedAlgorithmException
    extends DNSSECException {
        UnsupportedAlgorithmException(int n) {
            super("Unsupported algorithm: " + n);
        }
    }

    public static class DNSSECException
    extends Exception {
        DNSSECException(String string) {
            super(string);
        }
    }

    public static class Algorithm {
        public static final int RSAMD5 = 1;
        public static final int DH = 2;
        public static final int DSA = 3;
        public static final int ECC = 4;
        public static final int RSASHA1 = 5;
        public static final int DSA_NSEC3_SHA1 = 6;
        public static final int RSA_NSEC3_SHA1 = 7;
        public static final int RSASHA256 = 8;
        public static final int RSASHA512 = 10;
        public static final int INDIRECT = 252;
        public static final int PRIVATEDNS = 253;
        public static final int PRIVATEOID = 254;
        private static Mnemonic algs = new Mnemonic("DNSSEC algorithm", 2);

        private Algorithm() {
        }

        public static String string(int n) {
            return algs.getText(n);
        }

        public static int value(String string) {
            return algs.getValue(string);
        }

        static {
            algs.setMaximum(255);
            algs.setNumericAllowed(true);
            algs.add(1, "RSAMD5");
            algs.add(2, "DH");
            algs.add(3, "DSA");
            algs.add(4, "ECC");
            algs.add(5, "RSASHA1");
            algs.add(6, "DSA-NSEC3-SHA1");
            algs.add(7, "RSA-NSEC3-SHA1");
            algs.add(8, "RSASHA256");
            algs.add(10, "RSASHA512");
            algs.add(252, "INDIRECT");
            algs.add(253, "PRIVATEDNS");
            algs.add(254, "PRIVATEOID");
        }
    }
}

