/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp;

import org.jlibrtp.jlibrtp.Participant;
import org.jlibrtp.jlibrtp.RtcpPkt;
import org.jlibrtp.jlibrtp.StaticProcs;

public class RtcpPktRR
extends RtcpPkt {
    protected Participant[] reportees = null;
    protected long[] reporteeSsrc = null;
    protected int[] lossFraction = null;
    protected int[] lostPktCount = null;
    protected long[] extHighSeqRecv = null;
    protected long[] interArvJitter = null;
    protected long[] timeStampLSR = null;
    protected long[] delaySR = null;

    protected RtcpPktRR(Participant[] reportees, long ssrc) {
        this.packetType = 201;
        this.ssrc = ssrc;
        this.reportees = reportees;
    }

    protected RtcpPktRR(byte[] aRawPkt, int start, int rrCount) {
        int base;
        this.rawPkt = aRawPkt;
        if (!(rrCount >= 0 || super.parseHeaders(start) && this.packetType == 201 && this.length >= 1)) {
            this.problem = -201;
        }
        if (rrCount > 0) {
            base = start + 28;
        } else {
            base = start + 8;
            rrCount = this.itemCount;
            this.ssrc = StaticProcs.bytesToUIntLong(aRawPkt, start + 4);
        }
        if (rrCount > 0) {
            this.reporteeSsrc = new long[rrCount];
            this.lossFraction = new int[rrCount];
            this.lostPktCount = new int[rrCount];
            this.extHighSeqRecv = new long[rrCount];
            this.interArvJitter = new long[rrCount];
            this.timeStampLSR = new long[rrCount];
            this.delaySR = new long[rrCount];
            int i = 0;
            while (i < rrCount) {
                int pos = base + i * 24;
                this.reporteeSsrc[i] = StaticProcs.bytesToUIntLong(aRawPkt, pos);
                this.lossFraction[i] = aRawPkt[pos + 4];
                aRawPkt[pos + 4] = 0;
                this.lostPktCount[i] = (int)StaticProcs.bytesToUIntLong(aRawPkt, pos + 4);
                this.extHighSeqRecv[i] = StaticProcs.bytesToUIntLong(aRawPkt, pos + 8);
                this.interArvJitter[i] = StaticProcs.bytesToUIntLong(aRawPkt, pos + 12);
                this.timeStampLSR[i] = StaticProcs.bytesToUIntLong(aRawPkt, pos + 16);
                this.delaySR[i] = StaticProcs.bytesToUIntLong(aRawPkt, pos + 20);
                ++i;
            }
        }
    }

    @Override
    protected void encode() {
        byte[] rRs = null;
        if (this.reportees != null) {
            rRs = this.encodeRR();
            this.rawPkt = new byte[rRs.length + 8];
            System.arraycopy(rRs, 0, this.rawPkt, 8, rRs.length);
            this.itemCount = this.reportees.length;
        } else {
            this.rawPkt = new byte[8];
            this.itemCount = 0;
        }
        super.writeHeaders();
        byte[] someBytes = StaticProcs.uIntLongToByteWord(this.ssrc);
        System.arraycopy(someBytes, 0, this.rawPkt, 4, 4);
    }

    protected byte[] encodeRR() {
        byte[] ret = new byte[24 * this.reportees.length];
        int i = 0;
        while (i < this.reportees.length) {
            int offset = 24 * i;
            byte[] someBytes = StaticProcs.uIntLongToByteWord(this.reportees[i].ssrc);
            System.arraycopy(someBytes, 0, ret, offset, 4);
            someBytes = StaticProcs.uIntLongToByteWord(this.reportees[i].getLostPktCount());
            someBytes[0] = (byte)this.reportees[i].getFractionLost();
            System.arraycopy(someBytes, 0, ret, 4 + offset, 4);
            someBytes = StaticProcs.uIntLongToByteWord(this.reportees[i].getExtHighSeqRecv());
            System.arraycopy(someBytes, 0, ret, 8 + offset, 4);
            someBytes = this.reportees[i].interArrivalJitter >= 0.0 ? StaticProcs.uIntLongToByteWord((long)this.reportees[i].interArrivalJitter) : StaticProcs.uIntLongToByteWord(0L);
            System.arraycopy(someBytes, 0, ret, 12 + offset, 4);
            someBytes = StaticProcs.uIntLongToByteWord(this.reportees[i].timeStampLSR);
            System.arraycopy(someBytes, 0, ret, 16 + offset, 4);
            someBytes = this.reportees[i].timeReceivedLSR > 0L ? StaticProcs.uIntLongToByteWord(this.reportees[i].delaySinceLastSR()) : StaticProcs.uIntLongToByteWord(0L);
            System.arraycopy(someBytes, 0, ret, 20 + offset, 4);
            ++i;
        }
        return ret;
    }

    public void debugPrint() {
        System.out.println("RtcpPktRR.debugPrint() ");
        if (this.reportees != null) {
            int i = 0;
            while (i < this.reportees.length) {
                Participant part = this.reportees[i];
                System.out.println("     part.ssrc: " + part.ssrc + "  part.cname: " + part.cname);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.reporteeSsrc.length) {
                System.out.println("     reporteeSSRC: " + this.reporteeSsrc[i] + "  timeStampLSR: " + this.timeStampLSR[i]);
                ++i;
            }
        }
    }
}

